/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.jsonoverlay;

import com.fasterxml.jackson.databind.JsonNode;
import com.reprezen.kaizen.oasparser.jsonoverlay.JsonOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.ReferenceRegistry;

public abstract class OverlayFactory<V, OV extends JsonOverlay<V>> {
    private final Class<? super OV> overlayClass = this.getOverlayClass();

    public OV create(V value, JsonOverlay<?> parent, ReferenceRegistry refReg) {
        return this._create(value, parent, refReg);
    }

    public OV create(JsonNode json, JsonOverlay<?> parent, ReferenceRegistry refReg) {
        return this.create(json, parent, false, refReg);
    }

    public OV create(JsonNode json, JsonOverlay<?> parent, boolean partial, ReferenceRegistry refReg) {
        if (!partial && refReg.hasOverlay(json)) {
            JsonOverlay<?> overlay = refReg.getOverlay(json);
            if (parent != null) {
                overlay.setParent(parent);
            }
            return (OV)overlay;
        }
        OV overlay = this._create(json, parent, refReg);
        if (!partial) {
            refReg.setOverlay(json, (JsonOverlay<?>)overlay);
        }
        return overlay;
    }

    public boolean isCompatible(JsonOverlay<?> overlay) {
        return this.overlayClass.isAssignableFrom(overlay.getClass());
    }

    protected abstract Class<? super OV> getOverlayClass();

    public abstract OV _create(V var1, JsonOverlay<?> var2, ReferenceRegistry var3);

    public abstract OV _create(JsonNode var1, JsonOverlay<?> var2, ReferenceRegistry var3);
}

