/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.jsonoverlay;

import com.fasterxml.jackson.databind.JsonNode;
import com.reprezen.kaizen.oasparser.jsonoverlay.JsonOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.OverlayFactory;
import com.reprezen.kaizen.oasparser.jsonoverlay.ReferenceRegistry;
import com.reprezen.kaizen.oasparser.jsonoverlay.ScalarOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.SerializationOptions;
import java.math.BigDecimal;
import java.math.BigInteger;

public class PrimitiveOverlay
extends ScalarOverlay<Object> {
    public static OverlayFactory<Object, PrimitiveOverlay> factory = new OverlayFactory<Object, PrimitiveOverlay>(){

        @Override
        protected Class<PrimitiveOverlay> getOverlayClass() {
            return PrimitiveOverlay.class;
        }

        @Override
        public PrimitiveOverlay _create(Object value, JsonOverlay<?> parent, ReferenceRegistry refReg) {
            return new PrimitiveOverlay(value, parent, refReg);
        }

        @Override
        public PrimitiveOverlay _create(JsonNode json, JsonOverlay<?> parent, ReferenceRegistry refReg) {
            return new PrimitiveOverlay(json, (JsonOverlay)parent, refReg);
        }
    };

    private PrimitiveOverlay(JsonNode json, JsonOverlay<?> parent, ReferenceRegistry refReg) {
        super(json, parent, refReg);
    }

    private PrimitiveOverlay(Object value, JsonOverlay<?> parent, ReferenceRegistry refReg) {
        super(value, parent, refReg);
    }

    @Override
    public Object fromJson(JsonNode json) {
        if (json.isTextual()) {
            return json.textValue();
        }
        if (json.isNumber()) {
            return json.numberValue();
        }
        if (json.isBoolean()) {
            return json.booleanValue();
        }
        return null;
    }

    @Override
    public JsonNode toJson(SerializationOptions options) {
        if (this.value == null) {
            return PrimitiveOverlay.jsonMissing();
        }
        if (this.value instanceof String) {
            return PrimitiveOverlay.jsonScalar((String)this.value);
        }
        if (this.value instanceof BigDecimal) {
            return PrimitiveOverlay.jsonScalar((BigDecimal)this.value);
        }
        if (this.value instanceof BigInteger) {
            return PrimitiveOverlay.jsonScalar((BigInteger)this.value);
        }
        if (this.value instanceof Byte) {
            return PrimitiveOverlay.jsonScalar((Byte)this.value);
        }
        if (this.value instanceof Double) {
            return PrimitiveOverlay.jsonScalar((Double)this.value);
        }
        if (this.value instanceof Float) {
            return PrimitiveOverlay.jsonScalar(((Float)this.value).floatValue());
        }
        if (this.value instanceof Integer) {
            return PrimitiveOverlay.jsonScalar((Integer)this.value);
        }
        if (this.value instanceof Long) {
            return PrimitiveOverlay.jsonScalar((Long)this.value);
        }
        if (this.value instanceof Short) {
            return PrimitiveOverlay.jsonScalar((Short)this.value);
        }
        return null;
    }
}

