/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.jsonoverlay;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.reprezen.kaizen.oasparser.jsonoverlay.ChildListOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.ChildMapOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.ChildOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.IJsonOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.IPropertiesOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.JsonOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.ListOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.MapOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.OverlayFactory;
import com.reprezen.kaizen.oasparser.jsonoverlay.Reference;
import com.reprezen.kaizen.oasparser.jsonoverlay.ReferenceRegistry;
import com.reprezen.kaizen.oasparser.jsonoverlay.SerializationOptions;
import java.util.List;
import java.util.Map;

public abstract class PropertiesOverlay<V extends IPropertiesOverlay<V>>
extends JsonOverlay<V> {
    private List<ChildOverlay<?, ?>> children = Lists.newArrayList();
    protected Map<String, ChildOverlay<?, ?>> refables = Maps.newLinkedHashMap();
    private boolean elaborated = false;
    private boolean deferElaboration = false;

    protected PropertiesOverlay(JsonNode json, JsonOverlay<?> parent, ReferenceRegistry refReg) {
        super(json, parent, refReg);
        this.deferElaboration = json.isMissingNode();
    }

    public PropertiesOverlay(V value, JsonOverlay<?> parent, ReferenceRegistry refReg) {
        super(value, parent, refReg);
        this.elaborated = true;
    }

    protected void maybeElaborateChildrenAtCreation() {
        if (!this.deferElaboration) {
            this.ensureElaborated();
        }
    }

    protected void ensureElaborated() {
        if (!this.elaborated) {
            this.elaborateChildren();
            this.elaborated = true;
        }
    }

    protected abstract void elaborateChildren();

    @Override
    public boolean isElaborated() {
        return this.elaborated;
    }

    @Override
    public IJsonOverlay<?> _find(JsonPointer path) {
        for (ChildOverlay<?, ?> child : this.children) {
            IJsonOverlay<?> found;
            if (!child.matchesPath(path) || (found = child.find(child.tailPath(path))) == null) continue;
            return found;
        }
        return null;
    }

    @Override
    public V fromJson(JsonNode json) {
        IPropertiesOverlay result = (IPropertiesOverlay)((Object)this);
        return (V)result;
    }

    @Override
    public JsonNode toJson(SerializationOptions options) {
        MissingNode obj = PropertiesOverlay.jsonMissing();
        for (ChildOverlay<?, ?> child : this.children) {
            JsonNode childJson = child.toJson(options.minus(SerializationOptions.Option.KEEP_ONE_EMPTY));
            if (childJson.isMissingNode()) continue;
            obj = child.getPath().setInPath((JsonNode)obj, childJson);
        }
        JsonNode result = this.fixJson((JsonNode)obj);
        return result.size() > 0 || options.isKeepThisEmpty() ? result : PropertiesOverlay.jsonMissing();
    }

    protected JsonNode fixJson(JsonNode json) {
        return json;
    }

    @Override
    public V get(boolean elaborate) {
        if (elaborate) {
            this.ensureElaborated();
        }
        return (V)((IPropertiesOverlay)this.value);
    }

    @Override
    public void set(V value) {
        super.set(value);
        this.elaborateChildren();
    }

    protected <VC, OVC extends JsonOverlay<VC>> ChildOverlay<VC, OVC> createChild(boolean create, String path, JsonOverlay<?> parent, OverlayFactory<VC, OVC> factory) {
        return create ? this.createChild(path, parent, factory) : null;
    }

    protected <VC, OVC extends JsonOverlay<VC>> ChildOverlay<VC, OVC> createChild(String path, JsonOverlay<?> parent, OverlayFactory<VC, OVC> factory) {
        ChildOverlay<VC, OVC> child = new ChildOverlay<VC, OVC>(path, this.json.at("/" + path), parent, factory, this.refReg);
        if (child.getOverlay() != null) {
            child.getOverlay().setPathInParent(path);
        }
        this.children.add(child);
        return child;
    }

    protected <VC, OVC extends JsonOverlay<VC>> ChildMapOverlay<VC, OVC> createChildMap(boolean create, String path, JsonOverlay<?> parent, OverlayFactory<VC, OVC> factory, String keyPattern) {
        return create ? this.createChildMap(path, parent, factory, keyPattern) : null;
    }

    protected <VC, OVC extends JsonOverlay<VC>> ChildMapOverlay<VC, OVC> createChildMap(String path, JsonOverlay<?> parent, OverlayFactory<VC, OVC> factory, String keyPattern) {
        ChildMapOverlay child = new ChildMapOverlay(path, this.json.at(this.pathPointer(path)), parent, MapOverlay.getFactory(factory, keyPattern), this.refReg);
        child.getOverlay().setPathInParent(path);
        this.children.add(child);
        return child;
    }

    protected <VC, OVC extends JsonOverlay<VC>> ChildListOverlay<VC, OVC> createChildList(boolean create, String path, JsonOverlay<?> parent, OverlayFactory<VC, OVC> factory) {
        return create ? this.createChildList(path, parent, factory) : null;
    }

    protected <VC, OVC extends JsonOverlay<VC>> ChildListOverlay<VC, OVC> createChildList(String path, JsonOverlay<?> parent, OverlayFactory<VC, OVC> factory) {
        ChildListOverlay child = new ChildListOverlay(path, this.json.at(this.pathPointer(path)), parent, ListOverlay.getFactory(factory), this.refReg);
        child.getOverlay().setPathInParent(path);
        this.children.add(child);
        return child;
    }

    public Iterable<String> getRefablePaths() {
        return this.refables.keySet();
    }

    public boolean isReference(String path) {
        ChildOverlay<?, ?> child = this.refables.get(path);
        return child != null ? child.isReference() : false;
    }

    public Reference getReference(String path) {
        ChildOverlay<?, ?> child = this.refables.get(path);
        return child != null ? child.getReference() : null;
    }

    private JsonPointer pathPointer(String path) {
        return path == null || path.isEmpty() ? JsonPointer.compile((String)"") : JsonPointer.compile((String)("/" + path));
    }
}

