/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.jsonoverlay;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.google.common.base.Charsets;
import com.reprezen.kaizen.oasparser.jsonoverlay.ResolutionBase;
import com.reprezen.kaizen.oasparser.jsonoverlay.ResolutionBaseRegistry;
import com.reprezen.kaizen.oasparser.jsonoverlay.ResolutionException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.UUID;

public class Reference {
    private String refString;
    private String canonRefString;
    private ResolutionBase base;
    private String fragment;
    private Boolean isValid = null;
    private JsonNode json = null;
    private ResolutionException error;
    private String key;
    private final ResolutionBaseRegistry resolutionBaseRegistry;

    Reference(String refString, String canonicalRefString, ResolutionBase base) {
        this.refString = refString;
        this.canonRefString = canonicalRefString;
        this.resolutionBaseRegistry = base.getResolutionBaseRegistry();
        int pos = refString.indexOf(35);
        String relUrl = pos < 0 ? refString : refString.substring(0, pos);
        this.base = relUrl.isEmpty() ? base : this.resolutionBaseRegistry.of(base.comprehend(relUrl), false);
        if (pos >= 0) {
            this.fragment = refString.substring(pos);
        }
        if (this.fragment != null) {
            try {
                this.fragment = URLDecoder.decode(this.fragment, Charsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        this.key = this.canonRefString;
    }

    Reference(String refString, ResolutionBase base, ResolutionException e) {
        this.refString = refString;
        this.canonRefString = null;
        this.resolutionBaseRegistry = base.getResolutionBaseRegistry();
        this.fragment = null;
        this.base = base;
        this.isValid = false;
        this.error = e;
        this.key = UUID.randomUUID().toString();
    }

    public String getRefString() {
        return this.refString;
    }

    public String getCanonicalRefString() {
        return this.canonRefString;
    }

    public ResolutionBase getBase() {
        return this.base;
    }

    public String getFragment() {
        return this.fragment;
    }

    public JsonNode getJson() {
        if (this.isValid()) {
            return this.json;
        }
        return MissingNode.getInstance();
    }

    public boolean isValid() {
        return this.isValid != null && this.isValid != false;
    }

    public boolean isInvalid() {
        return this.isValid != null && this.isValid == false;
    }

    public boolean isResolved() {
        return this.isValid != null;
    }

    public ResolutionException getError() {
        return this.error;
    }

    public String getErrorReason() {
        return this.error != null ? this.error.getLocalizedMessage() : null;
    }

    public String getKey() {
        return this.key;
    }

    public JsonNode resolve() {
        if (!this.isResolved()) {
            try {
                JsonNode root = this.base.resolve();
                if (this.fragment == null) {
                    this.json = root;
                } else {
                    try {
                        this.json = root.at(this.fragment.substring(1));
                        if (this.json.isMissingNode()) {
                            throw new ResolutionException("JSON pointer does not address a value in the containing structure");
                        }
                    }
                    catch (IllegalArgumentException e) {
                        throw new ResolutionException("Failed to resolve JSON pointer", e);
                    }
                }
                this.isValid = true;
            }
            catch (ResolutionException e) {
                this.error = e;
                this.isValid = false;
                this.json = MissingNode.getInstance();
            }
        }
        return this.json;
    }

    public String toString() {
        return String.format("Reference[$ref=%s; canonical=%s; valid=%s, badReason=%s]", this.getRefString(), this.getCanonicalRefString(), this.isValid(), this.getErrorReason());
    }
}

