/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.jsonoverlay;

import com.fasterxml.jackson.databind.JsonNode;
import com.reprezen.kaizen.oasparser.jsonoverlay.ResolutionBaseRegistry;
import com.reprezen.kaizen.oasparser.jsonoverlay.ResolutionException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class ResolutionBase {
    private String urlString;
    private Boolean isValid = null;
    private ResolutionException error = null;
    private JsonNode json = null;
    private final ResolutionBaseRegistry resolutionBaseRegistry;

    ResolutionBase(String urlString, ResolutionBaseRegistry resolutionBaseRegistry) {
        this.urlString = urlString;
        this.isValid = null;
        this.resolutionBaseRegistry = resolutionBaseRegistry;
    }

    ResolutionBase(String urlString, ResolutionException e, ResolutionBaseRegistry resolutionBaseRegistry) {
        this.urlString = urlString;
        this.isValid = false;
        this.error = e;
        this.resolutionBaseRegistry = resolutionBaseRegistry;
    }

    ResolutionBase(String urlString, JsonNode json, ResolutionBaseRegistry resolutionBaseRegistry) {
        this.urlString = urlString;
        this.json = json;
        this.isValid = true;
        this.resolutionBaseRegistry = resolutionBaseRegistry;
    }

    public JsonNode getJson() {
        return this.json;
    }

    public String getUrlString() {
        return this.urlString;
    }

    public boolean isResolved() {
        return this.isValid != null;
    }

    public boolean isValid() {
        return this.isValid != null && this.isValid != false;
    }

    public boolean isInvalid() {
        return this.isValid != null && this.isValid == false;
    }

    public ResolutionException getError() {
        return this.error;
    }

    public String getErrorReason() {
        return this.error != null ? this.error.getLocalizedMessage() : null;
    }

    public JsonNode resolve() {
        if (this.isValid == null) {
            try {
                this.json = this.resolutionBaseRegistry.getJsonLoader().load(new URL(this.urlString));
                this.isValid = true;
            }
            catch (IOException e) {
                this.isValid = false;
                this.error = new ResolutionException(String.format("Failed to load document from '%s'", this.urlString), e);
                throw this.error;
            }
        } else if (this.isInvalid()) {
            throw this.error;
        }
        return this.json;
    }

    public String comprehend(String basedUrlString) {
        String fragment = "";
        if (basedUrlString.contains("#")) {
            int pos = basedUrlString.indexOf(35);
            fragment = basedUrlString.substring(pos);
            basedUrlString = basedUrlString.substring(0, pos);
        }
        try {
            URL url = new URL(new URL(this.urlString), basedUrlString);
            return url.toString() + fragment;
        }
        catch (MalformedURLException e) {
            throw new ResolutionException(String.format("Failed to comprehend reference string '%s' relative to resolution base '%s'", basedUrlString + fragment, this.urlString), e);
        }
    }

    public ResolutionBaseRegistry getResolutionBaseRegistry() {
        return this.resolutionBaseRegistry;
    }
}

