/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.jsonoverlay;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class SerializationOptions {
    private final Set<Option> options;

    public SerializationOptions(Option ... options) {
        this.options = Sets.newHashSet((Object[])options);
    }

    public SerializationOptions(Collection<Option> options) {
        this.options = Sets.newHashSet(options);
    }

    public SerializationOptions plus(Collection<Option> addOptions) {
        HashSet newOptions = Sets.newHashSet(this.options);
        newOptions.addAll(addOptions);
        return new SerializationOptions(newOptions);
    }

    public SerializationOptions plus(Option ... addOptions) {
        return this.plus(Arrays.asList(addOptions));
    }

    public SerializationOptions minus(Collection<Option> removeOptions) {
        HashSet newOptions = Sets.newHashSet(this.options);
        newOptions.removeAll(removeOptions);
        return new SerializationOptions(newOptions);
    }

    public SerializationOptions minus(Option ... removeOptions) {
        return this.minus(Arrays.asList(removeOptions));
    }

    public boolean isKeepEmpty() {
        return this.options.contains((Object)Option.KEEP_EMPTY);
    }

    public boolean isKeepOneEmpty() {
        return this.options.contains((Object)Option.KEEP_ONE_EMPTY);
    }

    public boolean isKeepThisEmpty() {
        return this.isKeepEmpty() || this.isKeepOneEmpty();
    }

    public boolean isFollowRefs() {
        return this.options.contains((Object)Option.FOLLOW_REFS);
    }

    public static enum Option {
        KEEP_EMPTY,
        KEEP_ONE_EMPTY,
        FOLLOW_REFS;

    }
}

