/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.jsonoverlay.gen;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.reprezen.kaizen.oasparser.jsonoverlay.ChildListOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.ChildMapOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.ChildOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.JsonOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.ListOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.MapOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.OverlayFactory;
import com.reprezen.kaizen.oasparser.jsonoverlay.Reference;
import com.reprezen.kaizen.oasparser.jsonoverlay.ReferenceRegistry;
import com.reprezen.kaizen.oasparser.jsonoverlay.gen.SimpleJavaGenerator;
import com.reprezen.kaizen.oasparser.jsonoverlay.gen.Template;
import com.reprezen.kaizen.oasparser.jsonoverlay.gen.TypeData;
import com.reprezen.kaizen.oasparser.jsonoverlay.gen.TypeGenerator;
import com.reprezen.kaizen.oasparser.model3.OpenApi3;
import com.reprezen.kaizen.oasparser.ovl3.OpenApiObjectImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ImplGenerator
extends TypeGenerator {
    public ImplGenerator(File dir, String intfPackage, String implPackage, String suffix, boolean preserve) {
        super(dir, intfPackage, implPackage, suffix, preserve);
    }

    @Override
    protected String getPackage() {
        return this.implPackage;
    }

    @Override
    protected Collection<String> getImports(TypeData.Type type) {
        return type.getRequiredImports("impl");
    }

    @Override
    public TypeGenerator.Members getOtherMembers(TypeData.Type type) {
        TypeGenerator.Members members = new TypeGenerator.Members();
        members.add(this.getElaborateChildrenMethod(type));
        members.add(this.getFactoryMethod(type));
        return members;
    }

    @Override
    public String getTypeDeclaration(TypeData.Type type, String suffix) {
        this.requireTypes(OpenApiObjectImpl.class, OpenApi3.class);
        this.requireTypes(type);
        return Template.t("public class ${name}${0} extends ${1} implements ${name}", type, suffix, this.getSuperType(type));
    }

    private String getSuperType(TypeData.Type type) {
        String superType = type.getExtensionOf();
        return superType != null ? TypeData.Type.getImplType(superType) : Template.t("OpenApiObjectImpl<${modelType}, ${name}>", type, new String[0]);
    }

    @Override
    protected TypeGenerator.Members getConstructors(TypeData.Type type) {
        TypeGenerator.Members members = new TypeGenerator.Members();
        members.add(Template.t("public ${implName}(JsonNode json, JsonOverlay<?> parent, ReferenceRegistry refReg)", type, new String[0]), this.code("super(json, parent, refReg);", "super.maybeElaborateChildrenAtCreation();"));
        this.requireTypes(JsonNode.class, JsonOverlay.class);
        members.add(Template.t("public ${implName}(${name} ${lcName}, JsonOverlay<?> parent, ReferenceRegistry refReg)", type, new String[0]), this.code(Template.t("super(${lcName}, parent, refReg);", type, new String[0]), "super.maybeElaborateChildrenAtCreation();"));
        return members;
    }

    @Override
    protected boolean skipField(TypeData.Field field) {
        return field.isNoImpl();
    }

    @Override
    protected TypeGenerator.Members getFieldMembers(TypeData.Field field) {
        this.requireTypes(field.getType(), field.getImplType());
        TypeGenerator.Members members = new TypeGenerator.Members();
        members.add(Template.t("private ${propType} ${propName} = null", field, new String[0]));
        switch (field.getStructure()) {
            case scalar: {
                this.requireTypes(ChildOverlay.class);
            }
            case collection: {
                this.requireTypes(Collection.class, ListOverlay.class, ChildListOverlay.class);
                break;
            }
            case map: {
                this.requireTypes(Map.class, MapOverlay.class, ChildMapOverlay.class);
                break;
            }
        }
        return members;
    }

    @Override
    protected TypeGenerator.Members getFieldMethods(TypeData.Field field) {
        TypeGenerator.Members methods = new TypeGenerator.Members();
        boolean first = true;
        String typeComment = field.getName();
        if (field.isRefable()) {
            this.requireTypes(Reference.class);
        }
        switch (field.getStructure()) {
            case scalar: {
                for (SimpleJavaGenerator.Member method : this.getScalarMethods(field)) {
                    methods.addMember(method).override().comment(first ? typeComment : null);
                    first = false;
                }
                break;
            }
            case collection: {
                for (SimpleJavaGenerator.Member method : this.getCollectionMethods(field)) {
                    methods.addMember(method).override().comment(first ? typeComment : null);
                    first = false;
                }
                break;
            }
            case map: {
                for (SimpleJavaGenerator.Member method : this.getMapMethods(field)) {
                    methods.addMember(method).override().comment(first ? typeComment : null);
                    first = false;
                }
                break;
            }
        }
        return methods;
    }

    private TypeGenerator.Members getScalarMethods(TypeData.Field field) {
        TypeGenerator.Members methods = new TypeGenerator.Members();
        String getDecl = Template.t("public ${type} get${name}()", field, new String[0]);
        String getBoolDecl = Template.t("public ${type} get${name}(boolean elaborate)", field, new String[0]);
        String setDecl = Template.t("public void set${name}(${type} ${lcName})", field, new String[0]);
        methods.add(getDecl, this.code(field, "return ${lcName}.get();"));
        methods.add(getBoolDecl, this.code(field, "return ${lcName}.get(elaborate);"));
        if (field.isBoolean()) {
            methods.add(Template.t("public boolean is${name}()", field, new String[0]), this.code(field, "return ${lcName}.get() != null ? ${lcName}.get() : ${boolDefault};"));
        }
        methods.add(setDecl, this.code(field, "this.${lcName}.set(${lcName});"));
        if (field.isRefable()) {
            methods.add(Template.t("public boolean is${name}Reference()", field, new String[0]), this.code(field, "return ${lcName} != null ? ${lcName}.isReference() : false;"));
            methods.add(Template.t("public Reference get${name}Reference()", field, new String[0]), this.code(field, "return ${lcName} != null ? ${lcName}.getReference() : null;"));
        }
        return methods;
    }

    private TypeGenerator.Members getCollectionMethods(TypeData.Field field) {
        TypeGenerator.Members methods = new TypeGenerator.Members();
        String getDecl = Template.t("public Collection<${collType}> get${plural}()", field, new String[0]);
        String getBoolDecl = Template.t("public Collection<${collType}> get${plural}(boolean elaborate)", field, new String[0]);
        String hasDecl = Template.t("public boolean has${plural}()", field, new String[0]);
        String iGetDecl = Template.t("public ${type} get${name}(int index)", field, new String[0]);
        String setDecl = Template.t("public void set${plural}(Collection<${collType}> ${lcPlural})", field, new String[0]);
        String iSetDecl = Template.t("public void set${name}(int index, ${type} ${lcName})", field, new String[0]);
        String addDecl = Template.t("public void add${name}(${type} ${lcName})", field, new String[0]);
        String insDecl = Template.t("public void insert${name}(int index, ${type} ${lcName})", field, new String[0]);
        String remDecl = Template.t("public void remove${name}(int index)", field, new String[0]);
        methods.add(getDecl, this.code(field, "return ${lcPlural}.get();"));
        methods.add(getBoolDecl, this.code(field, "return ${lcPlural}.get(elaborate);"));
        methods.add(hasDecl, this.code(field, "return ${lcPlural}.isPresent();"));
        methods.add(iGetDecl, this.code(field, "return ${lcPlural}.get(index);"));
        methods.add(setDecl, this.code(field, "this.${lcPlural}.set((Collection<${collType}>) ${lcPlural});"));
        methods.add(iSetDecl, this.code(field, "${lcPlural}.set(index, ${lcName});"));
        methods.add(addDecl, this.code(field, "${lcPlural}.add(${lcName});"));
        methods.add(insDecl, this.code(field, "${lcPlural}.insert(index, ${lcName});"));
        methods.add(remDecl, this.code(field, "${lcPlural}.remove(index);"));
        if (field.isRefable()) {
            methods.add(Template.t("public boolean is${name}Reference(int index)", field, new String[0]), this.code(field, "return ${lcPlural}.getChild(index).isReference();"));
            methods.add(Template.t("public Reference get${name}Reference(int index)", field, new String[0]), this.code(field, "return ${lcPlural}.getChild(index).getReference();"));
        }
        return methods;
    }

    private SimpleJavaGenerator.Member getElaborateChildrenMethod(TypeData.Type type) {
        String decl = "protected void elaborateChildren()";
        ArrayList code = Lists.newArrayList();
        for (TypeData.Field field : type.getFields().values()) {
            if (field.isNoImpl()) continue;
            code.addAll(this.code(field, "${propName} = ${propCons};"));
            if (!field.isRefable()) continue;
            code.addAll(this.code(field, "refables.put(${qpath}, ${propName});"));
        }
        return new SimpleJavaGenerator.Member(decl, code).override();
    }

    private SimpleJavaGenerator.Member getFactoryMethod(TypeData.Type type) {
        this.requireTypes(OverlayFactory.class, JsonNode.class, ReferenceRegistry.class);
        List<String> decl = Template.t(type, "public static OverlayFactory<${name}, ${implName}> factory = new OverlayFactory<${name}, ${implName}>() {", "    @Override", "    protected Class<? super ${implName}> getOverlayClass() {", "         return ${implName}.class;", "    }", "", "    @Override", "    public ${implName} _create(${name} ${lcName}, JsonOverlay<?> parent, ReferenceRegistry refReg) {", "        return new ${implName}(${lcName}, parent, refReg);", "    }", "", "    @Override", "    public ${implName} _create(JsonNode json, JsonOverlay<?> parent, ReferenceRegistry refReg) {", "        return new ${implName}(json, parent, refReg);", "    }", "}");
        return new SimpleJavaGenerator.Member(StringUtils.join(decl, (String)"\n"), null);
    }

    private TypeGenerator.Members getMapMethods(TypeData.Field field) {
        TypeGenerator.Members methods = new TypeGenerator.Members();
        methods.add(Template.t("public Map<String, ${collType}> get${plural}()", field, new String[0]), this.code(field, "return ${lcPlural}.get();"));
        methods.add(Template.t("public Map<String, ${collType}> get${plural}(boolean elaborate)", field, new String[0]), this.code(field, "return ${lcPlural}.get(elaborate);"));
        methods.add(Template.t("public boolean has${name}(String ${keyName})", field, new String[0]), this.code(field, "return ${lcPlural}.containsKey(${keyName});"));
        methods.add(Template.t("public ${type} get${name}(String ${keyName})", field, new String[0]), this.code(field, "return ${lcPlural}.get(${keyName});"));
        methods.add(Template.t("public void set${plural}(Map<String, ${type}> ${lcPlural})", field, new String[0]), this.code(field, "this.${lcPlural}.set(${lcPlural});"));
        methods.add(Template.t("public void set${name}(String ${keyName}, ${type} ${lcName})", field, new String[0]), this.code(field, "${lcPlural}.set(${keyName}, ${lcName});"));
        methods.add(Template.t("public void remove${name}(String ${keyName})", field, new String[0]), this.code(field, "${lcPlural}.remove(${keyName});"));
        if (field.isRefable()) {
            methods.add(Template.t("public boolean is${name}Reference(String key)", field, new String[0]), this.code(field, "ChildOverlay<${type}, ${implType}> child = ${lcPlural}.getChild(key);", "return child != null ? child.isReference() : false;"));
            methods.add(Template.t("public Reference get${name}Reference(String key)", field, new String[0]), this.code(field, "ChildOverlay<${type}, ${implType}> child = ${lcPlural}.getChild(key);", "return child != null ? child.getReference() : null;"));
        }
        return methods;
    }

    private Collection<String> code(String ... lines) {
        return Lists.newArrayList((Object[])lines);
    }

    private Collection<String> code(final TypeData.Field field, String ... lines) {
        return Lists.transform((List)Lists.newArrayList((Object[])lines), (Function)new Function<String, String>(){

            public String apply(String template) {
                return Template.t(template, field, new String[0]);
            }
        });
    }
}

