/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.jsonoverlay.gen;

import com.google.common.collect.Lists;
import com.reprezen.kaizen.oasparser.jsonoverlay.Reference;
import com.reprezen.kaizen.oasparser.jsonoverlay.gen.SimpleJavaGenerator;
import com.reprezen.kaizen.oasparser.jsonoverlay.gen.Template;
import com.reprezen.kaizen.oasparser.jsonoverlay.gen.TypeData;
import com.reprezen.kaizen.oasparser.jsonoverlay.gen.TypeGenerator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class InterfaceGenerator
extends TypeGenerator {
    public InterfaceGenerator(File dir, String intfPackage, String implPackage, String suffix, boolean preserve) {
        super(dir, intfPackage, implPackage, suffix, preserve);
    }

    @Override
    protected String getPackage() {
        return this.intfPackage;
    }

    @Override
    protected String getTypeDeclaration(TypeData.Type type, String suffix) {
        String superType = this.getSuperType(type);
        this.requireTypes(superType);
        this.requireTypes(type.getExtendInterfaces());
        ArrayList allTypes = Lists.newArrayList((Object[])new String[]{superType});
        allTypes.addAll(type.getExtendInterfaces());
        return Template.t("public interface ${name} extends ${0}", type, StringUtils.join((Iterable)allTypes, (String)", "));
    }

    @Override
    protected Collection<String> getImports(TypeData.Type type) {
        return type.getRequiredImports("intf");
    }

    private String getSuperType(TypeData.Type type) {
        String superType = type.getExtensionOf();
        return superType != null ? superType : Template.t("OpenApiObject<${modelType}, ${name}>", type, new String[0]);
    }

    @Override
    protected TypeGenerator.Members getFieldMethods(TypeData.Field field) {
        TypeGenerator.Members methods = new TypeGenerator.Members();
        this.requireTypes(field.getType());
        boolean first = true;
        String typeComment = field.getName();
        if (field.isRefable()) {
            this.requireTypes(Reference.class);
        }
        switch (field.getStructure()) {
            case scalar: {
                for (SimpleJavaGenerator.Member method : this.getScalarMethods(field)) {
                    methods.addMember(method).comment(first ? typeComment : null);
                    first = false;
                }
                break;
            }
            case collection: {
                this.requireTypes(Collection.class);
                for (SimpleJavaGenerator.Member method : this.getCollectionMethods(field)) {
                    methods.addMember(method).comment(first ? typeComment : null);
                    first = false;
                }
                break;
            }
            case map: {
                this.requireTypes(Map.class);
                for (SimpleJavaGenerator.Member method : this.getMapMethods(field)) {
                    methods.addMember(method).comment(first ? typeComment : null);
                    first = false;
                }
                break;
            }
        }
        return methods;
    }

    private TypeGenerator.Members getScalarMethods(TypeData.Field field) {
        TypeGenerator.Members methods = new TypeGenerator.Members();
        methods.add(Template.t("${type} get${name}()", field, new String[0]));
        methods.add(Template.t("${type} get${name}(boolean elaborate)", field, new String[0]));
        if (field.getType().equals("Boolean")) {
            methods.add(Template.t("boolean is${name}()", field, new String[0]));
        }
        methods.add(Template.t("void set${name}(${type} ${lcName})", field, new String[0]));
        if (field.isRefable()) {
            methods.add(Template.t("boolean is${name}Reference()", field, new String[0]));
            methods.add(Template.t("Reference get${name}Reference()", field, new String[0]));
        }
        return methods;
    }

    private TypeGenerator.Members getCollectionMethods(TypeData.Field field) {
        TypeGenerator.Members methods = new TypeGenerator.Members();
        methods.add(Template.t("Collection<${collType}> get${plural}()", field, new String[0]));
        methods.add(Template.t("Collection<${collType}> get${plural}(boolean elaborate)", field, new String[0]));
        methods.add(Template.t("boolean has${plural}()", field, new String[0]));
        methods.add(Template.t("${type} get${name}(int index)", field, new String[0]));
        methods.add(Template.t("void set${plural}(Collection<${collType}> ${lcPlural})", field, new String[0]));
        methods.add(Template.t("void set${name}(int index, ${type} ${lcName})", field, new String[0]));
        methods.add(Template.t("void add${name}(${type} ${lcName})", field, new String[0]));
        methods.add(Template.t("void insert${name}(int index, ${type} ${lcName})", field, new String[0]));
        methods.add(Template.t("void remove${name}(int index)", field, new String[0]));
        if (field.isRefable()) {
            methods.add(Template.t("boolean is${name}Reference(int index)", field, new String[0]));
            methods.add(Template.t("Reference get${name}Reference(int index)", field, new String[0]));
        }
        return methods;
    }

    private TypeGenerator.Members getMapMethods(TypeData.Field field) {
        TypeGenerator.Members methods = new TypeGenerator.Members();
        methods.add(Template.t("Map<String, ${collType}> get${plural}()", field, new String[0]));
        methods.add(Template.t("Map<String, ${collType}> get${plural}(boolean elaborate)", field, new String[0]));
        methods.add(Template.t("boolean has${name}(String ${keyName})", field, new String[0]));
        methods.add(Template.t("${type} get${name}(String ${keyName})", field, new String[0]));
        methods.add(Template.t("void set${plural}(Map<String, ${collType}> ${lcPlural})", field, new String[0]));
        methods.add(Template.t("void set${name}(String ${keyName}, ${type} ${lcName})", field, new String[0]));
        methods.add(Template.t("void remove${name}(String ${keyName})", field, new String[0]));
        if (field.isRefable()) {
            methods.add(Template.t("boolean is${name}Reference(String key)", field, new String[0]));
            methods.add(Template.t("Reference get${name}Reference(String key)", field, new String[0]));
        }
        return methods;
    }
}

