/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.jsonoverlay.gen;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.reprezen.kaizen.oasparser.jsonoverlay.gen.CodeGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class SimpleJavaGenerator {
    private String pkg;
    private Set<String> imports = Sets.newHashSet();
    private String declaration;
    private List<Member> members = Lists.newArrayList();
    private String fileComment;
    private static int indentation = 4;

    public SimpleJavaGenerator(String pkg, String declaration) {
        this.pkg = pkg;
        this.declaration = declaration;
    }

    public String getPackage() {
        return this.pkg;
    }

    public void setPackage(String pkg) {
        this.pkg = pkg;
    }

    public int getIndentation() {
        return indentation;
    }

    public void setIndentation(int indentation) {
        SimpleJavaGenerator.indentation = indentation;
    }

    public Collection<Member> getMembers() {
        return this.members;
    }

    public void addMember(Member member) {
        this.members.add(member);
    }

    public void addMembers(Collection<Member> members) {
        this.members.addAll(members);
    }

    public void addGeneratedMembers(Collection<Member> members) {
        for (Member member : members) {
            this.members.add(member.generated(true));
        }
    }

    public void setFileComment(String fileComment) {
        this.fileComment = fileComment;
    }

    public void addImport(String imp) {
        if (imp != null) {
            this.imports.add(imp);
        }
    }

    public String format() {
        String result = String.format("%spackage %s;\n\n%s\n\n%s {\n\n", this.fileComment != null ? this.fileComment : "", this.pkg, this.getImports(), this.declaration);
        for (Member method : this.members) {
            result = result + method.format() + "\n";
        }
        return result + "}\n";
    }

    private static String indent(int n) {
        return StringUtils.repeat((String)" ", (int)(indentation * n));
    }

    private static String indent(int n, String text) {
        String[] lines = StringUtils.split((String)text, (String)"\n");
        String result = "";
        for (String line : lines) {
            result = result + SimpleJavaGenerator.indent(n) + line + "\n";
        }
        return result;
    }

    public String getImports() {
        ArrayList importsList = Lists.newArrayList(this.imports);
        Collections.sort(importsList);
        return StringUtils.join((Iterable)Collections2.transform((Collection)importsList, (Function)new Function<String, String>(){

            public String apply(String imp) {
                return "import " + imp + ";";
            }
        }), (String)"\n");
    }

    public static class Member {
        private String declaration;
        private Collection<String> code;
        private String comment;
        private boolean override;
        private boolean generated;
        private boolean complete;

        public Member(String declaration, Collection<String> code) {
            this.declaration = declaration;
            this.code = code;
        }

        public String getDeclaration() {
            return this.declaration;
        }

        public Collection<String> getCode() {
            return this.code;
        }

        public Member override() {
            this.override = true;
            return this;
        }

        public Member comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Member generated(boolean generated) {
            this.generated = generated;
            return this;
        }

        public Member complete(boolean complete) {
            this.complete = complete;
            return this;
        }

        public String format() {
            if (this.complete) {
                return SimpleJavaGenerator.indent(1, this.declaration);
            }
            String override = this.override ? SimpleJavaGenerator.indent(1) + "@Override\n" : "";
            String gen = this.generated ? SimpleJavaGenerator.indent(1) + String.format("@Generated(\"%s\")\n", CodeGenerator.class.getName()) : "";
            String comment = this.comment != null ? SimpleJavaGenerator.indent(1) + "// " + this.comment + "\n" : "";
            String header = comment + override + gen + SimpleJavaGenerator.indent(1) + this.declaration;
            return this.code == null || this.code.isEmpty() ? header + ";\n" : header + " {\n" + this.formatCode() + "\n" + SimpleJavaGenerator.indent(1) + "}\n";
        }

        private String formatCode() {
            return SimpleJavaGenerator.indent(2) + StringUtils.join(this.code, (String)("\n" + SimpleJavaGenerator.indent(3)));
        }
    }
}

