/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.jsonoverlay.gen;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.reprezen.kaizen.oasparser.jsonoverlay.gen.TypeData;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;

public class Template {
    private static Pattern varPat = Pattern.compile("\\$\\{([a-zA-Z]+|\\d+)\\}");

    public static <T> String t(String template, T item, String ... args) {
        Matcher matcher = varPat.matcher(template);
        StringBuffer result = new StringBuffer();
        int start = 0;
        while (matcher.find()) {
            result.append(template.substring(start, matcher.start()));
            result.append(Template.replacement(matcher.group(1), item, args));
            start = matcher.end();
        }
        result.append(template.substring(start));
        return result.toString();
    }

    public static <T> List<String> t(final T item, String ... templates) {
        return Lists.transform((List)Lists.newArrayList((Object[])templates), (Function)new Function<String, String>(){

            public String apply(String template) {
                return Template.t(template, item, new String[0]);
            }
        });
    }

    private static String replacement(String var, TypeData.Field field, String[] args) {
        switch (var) {
            case "name": {
                return field.getName();
            }
            case "lcName": {
                return field.getLcName();
            }
            case "plural": {
                return field.getPlural();
            }
            case "lcPlural": {
                return field.getLcPlural();
            }
            case "type": {
                String type = field.getType();
                return "Primitive".equals(type) ? "Object" : type;
            }
            case "implType": {
                return field.getImplType();
            }
            case "collType": {
                String type = field.getType();
                return "Primitive".equals(type) ? "Object" : type;
            }
            case "keyName": {
                return field.getKeyName();
            }
            case "id": {
                return field.getId();
            }
            case "qid": {
                return Template.quote(field.getId());
            }
            case "qpath": {
                return Template.quote(field.getParentPath());
            }
            case "qpointer": {
                String path = field.getParentPath();
                path = path == null || path.isEmpty() ? "" : "/" + path;
                return Template.quote(path);
            }
            case "qkeyPat": {
                return Template.quote(field.getKeyPattern());
            }
            case "boolDefault": {
                return String.valueOf(field.getBoolDefault());
            }
            case "propName": {
                return field.getPropertyName();
            }
            case "propType": {
                return field.getPropertyType();
            }
            case "propCons": {
                return field.getPropertyNew();
            }
            case "overlayType": {
                return field.getOverlayType();
            }
        }
        return args[Integer.valueOf(var)];
    }

    private static String replacement(String var, TypeData.Type type, String[] args) {
        switch (var) {
            case "name": {
                return type.getName();
            }
            case "lcName": {
                return type.getLcName();
            }
            case "implName": {
                return type.getImplType();
            }
            case "modelType": {
                return type.getTypeData().getModelType();
            }
        }
        return args[Integer.valueOf(var)];
    }

    private static String replacement(String var, Object item, String[] args) {
        if (item instanceof TypeData.Field) {
            return Template.replacement(var, (TypeData.Field)item, args);
        }
        if (item instanceof TypeData.Type) {
            return Template.replacement(var, (TypeData.Type)item, args);
        }
        throw new UnsupportedOperationException();
    }

    private static String quote(String s) {
        return s != null ? "\"" + StringEscapeUtils.escapeJava((String)s) + "\"" : "null";
    }
}

