/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.jsonoverlay.gen;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseException;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.reprezen.kaizen.oasparser.OpenApi;
import com.reprezen.kaizen.oasparser.jsonoverlay.BooleanOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.ChildListOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.ChildMapOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.ChildOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.IJsonOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.IntegerOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.JsonOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.ListOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.MapOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.NumberOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.ObjectOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.OverlayFactory;
import com.reprezen.kaizen.oasparser.jsonoverlay.Primitive;
import com.reprezen.kaizen.oasparser.jsonoverlay.PrimitiveOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.Reference;
import com.reprezen.kaizen.oasparser.jsonoverlay.ReferenceRegistry;
import com.reprezen.kaizen.oasparser.jsonoverlay.StringOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.gen.SimpleJavaGenerator;
import com.reprezen.kaizen.oasparser.jsonoverlay.gen.Template;
import com.reprezen.kaizen.oasparser.jsonoverlay.gen.TypeData;
import com.reprezen.kaizen.oasparser.val.ValidationResults;
import com.reprezen.kaizen.oasparser.val.Validator;
import com.reprezen.kaizen.oasparser.val3.OpenApi3Validator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Generated;
import org.apache.commons.io.FileUtils;

public abstract class TypeGenerator {
    private File dir;
    protected String intfPackage;
    protected String implPackage;
    private String suffix;
    private boolean preserve;
    private Set<String> requiredTypes = Sets.newHashSet();
    private static Set<String> autoTypes = TypeGenerator.getAutoTypes();
    private static Map<String, String> knownTypes = TypeGenerator.getKnownTypes();

    public TypeGenerator(File dir, String intfPackage, String implPackage, String suffix, boolean preserve) {
        this.dir = dir;
        this.intfPackage = intfPackage;
        this.implPackage = implPackage;
        this.suffix = suffix;
        this.preserve = preserve;
    }

    protected abstract String getTypeDeclaration(TypeData.Type var1, String var2);

    public void generate(TypeData.Type type) throws IOException {
        File javaFile = new File(this.dir, Template.t("${name}${0}.java", type, this.suffix));
        System.out.println("Generating " + javaFile.getCanonicalFile());
        CompilationUnit existing = this.preserve && javaFile.exists() ? this.tryParse(javaFile) : null;
        String declaration = this.getTypeDeclaration(type, this.suffix);
        SimpleJavaGenerator gen = new SimpleJavaGenerator(this.getPackage(), declaration);
        if (existing != null) {
            this.copyFileComment(gen, existing);
            this.addManualMethods(gen, existing);
        }
        this.requireTypes(this.getImports(type));
        this.addGeneratedMembers(type, gen);
        this.requireTypes(Generated.class);
        this.resolveImports(type, gen);
        FileUtils.write((File)javaFile, (CharSequence)gen.format(), (Charset)Charsets.UTF_8);
    }

    protected abstract String getPackage();

    protected abstract Collection<String> getImports(TypeData.Type var1);

    protected void requireTypes(Class<?> ... types) {
        this.requireTypes(Collections2.transform(Arrays.asList(types), (Function)new Function<Class<?>, String>(){

            public String apply(Class<?> type) {
                return type.getSimpleName();
            }
        }).toArray(new String[types.length]));
    }

    protected void requireTypes(TypeData.Type ... types) {
        this.requireTypes(Collections2.transform(Arrays.asList(types), (Function)new Function<TypeData.Type, String>(){

            public String apply(TypeData.Type type) {
                return type.getName();
            }
        }));
    }

    protected void requireTypes(String ... types) {
        this.requireTypes(Arrays.asList(types));
    }

    protected void requireTypes(Collection<String> types) {
        this.requiredTypes.addAll(Collections2.transform(types, (Function)new Function<String, String>(){

            public String apply(String type) {
                return type.contains("<") ? type.substring(0, type.indexOf("<")) : type;
            }
        }));
    }

    private void resolveImports(TypeData.Type type, SimpleJavaGenerator gen) {
        Map<String, String> importMap = type.getTypeData().getImports();
        Map<String, TypeData.Type> typeMap = type.getTypeData().getTypeMap();
        for (String requiredType : this.requiredTypes) {
            gen.addImport(this.resolveImport(requiredType, typeMap, importMap));
        }
    }

    private static Set<String> getAutoTypes() {
        HashSet results = Sets.newHashSet();
        ArrayList autos = Lists.newArrayList((Object[])new Class[]{String.class, Integer.class, Number.class, Boolean.class, Primitive.class, Object.class});
        for (Class cls : autos) {
            results.add(cls.getSimpleName());
        }
        return results;
    }

    private static Map<String, String> getKnownTypes() {
        HashMap results = Maps.newHashMap();
        ArrayList overlays = Lists.newArrayList((Object[])new Class[]{Generated.class, Collection.class, Map.class, Optional.class, JsonNode.class, ObjectNode.class, JsonNodeFactory.class, JsonPointer.class, JsonOverlay.class, IJsonOverlay.class, ChildOverlay.class, ChildMapOverlay.class, ChildListOverlay.class, OverlayFactory.class, Reference.class, ReferenceRegistry.class, Inject.class, StringOverlay.class, IntegerOverlay.class, NumberOverlay.class, BooleanOverlay.class, PrimitiveOverlay.class, ObjectOverlay.class, ListOverlay.class, MapOverlay.class, Validator.class, ValidationResults.class, OpenApi3Validator.class, OpenApi.class, ValidationResults.Severity.class});
        for (Class cls : overlays) {
            results.put(cls.getSimpleName(), cls.getName().replaceAll("\\$", "."));
        }
        return results;
    }

    private String resolveImport(String type, Map<String, TypeData.Type> typeMap, Map<String, String> importMap) {
        if (importMap.containsKey(type)) {
            String imp = importMap.get(type);
            if (imp.equals("_intf")) {
                return this.intfPackage + "." + type;
            }
            if (imp.equals("_impl")) {
                return this.implPackage + "." + type;
            }
            return imp;
        }
        if (typeMap.containsKey(type)) {
            return this.intfPackage + "." + type;
        }
        if (!this.suffix.isEmpty() && type.endsWith(this.suffix) && typeMap.containsKey(type.substring(0, type.length() - this.suffix.length()))) {
            return this.implPackage + "." + type;
        }
        if (autoTypes.contains(type)) {
            return null;
        }
        if (knownTypes.containsKey(type)) {
            return knownTypes.get(type);
        }
        throw new RuntimeException("Unable to resolve import for type: " + type);
    }

    protected void addGeneratedMembers(TypeData.Type type, SimpleJavaGenerator gen) {
        gen.addGeneratedMembers(this.getConstructors(type));
        for (TypeData.Field field : type.getFields().values()) {
            if (this.skipField(field)) continue;
            gen.addGeneratedMembers(this.getFieldMembers(field));
        }
        for (TypeData.Field field : type.getFields().values()) {
            if (this.skipField(field)) continue;
            gen.addGeneratedMembers(this.getFieldMethods(field));
        }
        gen.addGeneratedMembers(this.getOtherMembers(type));
    }

    protected boolean skipField(TypeData.Field field) {
        return false;
    }

    private CompilationUnit tryParse(File file) {
        try {
            return JavaParser.parse((File)file);
        }
        catch (ParseException | IOException e) {
            System.err.println("ABORTING AFTER PARTIAL GENERATION!");
            System.err.printf("Parsing of file %s failed; so generation cannot continue without destroying manual code.\n", file);
            System.err.println("Please restore generated code artifacts to a known good state before regenerating");
            System.err.println("Parse Error:");
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    private void copyFileComment(SimpleJavaGenerator gen, CompilationUnit existing) {
        Comment fileComment = existing.getComment();
        if (fileComment != null) {
            gen.setFileComment(fileComment.toString());
        }
    }

    private void addManualMethods(SimpleJavaGenerator gen, CompilationUnit existing) {
        for (TypeDeclaration type : existing.getTypes()) {
            for (BodyDeclaration member : type.getMembers()) {
                if (!(member instanceof MethodDeclaration) && !(member instanceof FieldDeclaration) && !(member instanceof ConstructorDeclaration) || this.isGenerated(member)) continue;
                gen.addMember(new SimpleJavaGenerator.Member(member.toString(), null).complete(true));
            }
        }
    }

    private boolean isGenerated(BodyDeclaration node) {
        for (AnnotationExpr annotation : node.getAnnotations()) {
            if (!annotation.getName().toString().equals("Generated")) continue;
            return true;
        }
        return false;
    }

    protected Members getConstructors(TypeData.Type type) {
        return new Members();
    }

    protected Members getFieldMembers(TypeData.Field field) {
        return new Members();
    }

    protected Members getFieldMethods(TypeData.Field field) {
        return new Members();
    }

    protected Members getOtherMembers(TypeData.Type type) {
        return new Members();
    }

    protected SimpleJavaGenerator.Member addMember(String declaration, Collection<String> code) {
        SimpleJavaGenerator.Member member = new SimpleJavaGenerator.Member(declaration, code);
        return member;
    }

    protected final SimpleJavaGenerator.Member addMember(String declaration) {
        return this.addMember(declaration, null);
    }

    protected static class Members
    extends ArrayList<SimpleJavaGenerator.Member> {
        private static final long serialVersionUID = 1L;

        protected Members() {
        }

        public SimpleJavaGenerator.Member add(String declaration, Collection<String> code) {
            SimpleJavaGenerator.Member member = new SimpleJavaGenerator.Member(declaration, code);
            super.add(member);
            return member;
        }

        public SimpleJavaGenerator.Member add(String declaration) {
            return this.add(declaration, null);
        }

        public SimpleJavaGenerator.Member addMember(SimpleJavaGenerator.Member member) {
            this.add(member);
            return member;
        }
    }
}

