/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.val;

import com.fasterxml.jackson.databind.JsonNode;
import com.reprezen.kaizen.oasparser.jsonoverlay.JsonOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.ListOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.MapOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.PropertiesOverlay;
import com.reprezen.kaizen.oasparser.jsonoverlay.Reference;
import com.reprezen.kaizen.oasparser.val.Messages;
import com.reprezen.kaizen.oasparser.val.ValidationResults;
import com.reprezen.kaizen.oasparser.val.ValidatorBase;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class OverlayValidator<T>
extends ValidatorBase<T> {
    @Override
    public void validate(T overlay, ValidationResults results) {
        this.checkReferences((JsonOverlay)overlay, results);
    }

    public void validate(T overlay, ValidationResults results, Class<? extends JsonNode> allowedNodeType) {
        this.validate(overlay, results, Collections.singleton(allowedNodeType));
    }

    public void validate(T object, ValidationResults results, Set<Class<? extends JsonNode>> allowedNodeTypes) {
        JsonOverlay overlay = (JsonOverlay)object;
        JsonNode json = overlay.toJson();
        boolean isValidJsonType = false;
        for (Class<? extends JsonNode> type : allowedNodeTypes) {
            if (!type.isAssignableFrom(json.getClass())) continue;
            isValidJsonType = true;
            break;
        }
        boolean bl = isValidJsonType = isValidJsonType || json.isMissingNode();
        if (!isValidJsonType) {
            results.addError(Messages.m.msg("WrongTypeJson|Property bound to incompatible JSON Node type", json.getNodeType(), allowedNodeTypes));
        }
    }

    private void checkReferences(JsonOverlay<?> overlay, ValidationResults results) {
        if (overlay instanceof ListOverlay) {
            this.checkReferences((ListOverlay)overlay, results);
        } else if (overlay instanceof MapOverlay) {
            this.checkReferences((MapOverlay)overlay, results);
        } else if (overlay instanceof PropertiesOverlay) {
            this.checkReferences((PropertiesOverlay)overlay, results);
        }
    }

    private void checkReferences(ListOverlay<?, ?> list, ValidationResults results) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.isReference(i)) continue;
            this.checkReference(list.getReference(i), results, Integer.toString(i));
        }
    }

    private void checkReferences(MapOverlay<?, ?> map, ValidationResults results) {
        for (String key : ((Map)map.get()).keySet()) {
            if (!map.isReference(key)) continue;
            this.checkReference(map.getReference(key), results, key);
        }
    }

    private void checkReferences(PropertiesOverlay<?> props, ValidationResults results) {
        if (props.isElaborated()) {
            for (String path : props.getRefablePaths()) {
                if (!props.isReference(path)) continue;
                this.checkReference(props.getReference(path), results, path);
            }
        }
    }

    private void checkReference(Reference ref, ValidationResults results, String crumb) {
        if (ref.isInvalid()) {
            results.addError(Messages.m.msg("BadRef|JSON reference node was not resolved", ref.getRefString(), ref.getErrorReason()), crumb);
        }
    }
}

