/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.val;

import com.google.common.collect.Lists;
import com.reprezen.kaizen.oasparser.jsonoverlay.JsonOverlay;
import com.reprezen.kaizen.oasparser.val.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ValidationResults {
    List<ValidationItem> items = Lists.newArrayList();
    List<String> crumbs = Collections.emptyList();

    public void addInfo(String msg) {
        this.items.add(new ValidationItem(Severity.INFO, msg, this.crumbs));
    }

    public void addInfo(String msg, String crumb) {
        this.items.add(new ValidationItem(Severity.INFO, msg, this.crumbs, crumb));
    }

    public void addWarning(String msg) {
        this.items.add(new ValidationItem(Severity.WARNING, msg, this.crumbs));
    }

    public void addWarning(String msg, String crumb) {
        this.items.add(new ValidationItem(Severity.WARNING, msg, this.crumbs, crumb));
    }

    public void addError(String msg) {
        this.items.add(new ValidationItem(Severity.ERROR, msg, this.crumbs));
    }

    public void addError(String msg, String crumb) {
        this.items.add(new ValidationItem(Severity.ERROR, msg, this.crumbs, crumb));
    }

    public void add(ValidationResults results) {
        this.items.addAll(results.getItems());
    }

    public Collection<ValidationItem> getItems() {
        return this.items;
    }

    public Severity getSeverity() {
        Severity severity = Severity.NONE;
        for (ValidationItem item : this.items) {
            if (item.getSeverity().gt(severity) && (severity = item.getSeverity()) == Severity.MAX_SEVERITY) break;
        }
        return severity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends JsonOverlay<?>> void validateWithCrumb(String crumb, Validator<T> validator, T object) {
        List<String> priorCrumbs = this.crumbs;
        try {
            if (crumb != null) {
                this.crumbs = ValidationResults.appendCrumb(crumb, priorCrumbs);
            }
            validator.validate(object, this);
        }
        finally {
            this.crumbs = priorCrumbs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withCrumb(String crumb, Runnable code) {
        List<String> priorCrumbs = this.crumbs;
        try {
            this.crumbs = ValidationResults.appendCrumb(crumb, priorCrumbs);
            code.run();
        }
        finally {
            this.crumbs = priorCrumbs;
        }
    }

    private static List<String> appendCrumb(String crumb, List<String> existingCrumbs) {
        if (crumb != null) {
            ArrayList newCrumbs = Lists.newArrayList(existingCrumbs);
            newCrumbs.add(crumb);
            return newCrumbs;
        }
        return existingCrumbs;
    }

    public static class ValidationItem {
        private Severity severity;
        private String msg;
        private List<String> crumbs;

        public ValidationItem(Severity severity, String msg, List<String> crumbs) {
            this.severity = severity;
            this.msg = msg;
            this.crumbs = crumbs;
        }

        public ValidationItem(Severity severity, String msg, List<String> crumbs, String crumb) {
            this(severity, msg, ValidationResults.appendCrumb(crumb, crumbs));
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public String getMsg() {
            return this.msg;
        }

        public List<String> getCrumbs() {
            return this.crumbs;
        }

        public String toString() {
            String label = this.crumbs != null & !this.crumbs.isEmpty() ? StringUtils.join(this.crumbs, (char)'.') + ": " : "";
            return label + this.msg;
        }
    }

    public static enum Severity {
        NONE,
        INFO,
        WARNING,
        ERROR;

        public static final Severity MAX_SEVERITY;

        public boolean lt(Severity other) {
            return this.compareTo(other) < 0;
        }

        public boolean le(Severity other) {
            return this.compareTo(other) <= 0;
        }

        public boolean gt(Severity other) {
            return this.compareTo(other) > 0;
        }

        public boolean ge(Severity other) {
            return this.compareTo(other) >= 0;
        }

        static {
            MAX_SEVERITY = ERROR;
        }
    }
}

