/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.val;

import com.google.common.collect.Sets;
import com.reprezen.kaizen.oasparser.jsonoverlay.JsonOverlay;
import com.reprezen.kaizen.oasparser.val.Messages;
import com.reprezen.kaizen.oasparser.val.NumericUtils;
import com.reprezen.kaizen.oasparser.val.ValidationResults;
import com.reprezen.kaizen.oasparser.val.Validator;
import com.reprezen.kaizen.oasparser.val.oasparser.fake.scheme.Handler;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.print.attribute.standard.Severity;

public abstract class ValidatorBase<T>
implements Validator<T> {
    public static final String SPECIAL_SCHEME = Handler.class.getPackage().getName().substring(ValidatorBase.class.getPackage().getName().length() + 1);
    private static boolean specialSchemeInited = false;

    @Override
    public ValidationResults validate(T object) {
        ValidationResults results = new ValidationResults();
        this.validate(object, results);
        return results;
    }

    @Override
    public void validate(final T object, final ValidationResults results, String crumb) {
        results.withCrumb(crumb, new Runnable(){

            @Override
            public void run() {
                ValidatorBase.this.validate(object, results);
            }
        });
    }

    public void validateString(String value, ValidationResults results, boolean required, String crumb) {
        this.validateString(value, results, required, (Pattern)null, crumb);
    }

    public void validateString(String value, ValidationResults results, boolean required, String pattern, String crumb) {
        this.validateString(value, results, required, Pattern.compile(pattern), crumb);
    }

    public void validateString(String value, ValidationResults results, boolean required, Pattern pattern, String crumb) {
        this.checkMissing(required, value, results, crumb);
        if (value != null && pattern != null && !pattern.matcher(value).matches()) {
            results.addError(Messages.m.msg("PatternMatchFail|String value does not match required pattern", value, pattern), crumb);
        }
    }

    public void validateUrl(String value, ValidationResults results, boolean required, String crumb) {
        this.validateUrl(value, results, required, crumb, false);
    }

    public void validateUrl(String value, ValidationResults results, boolean required, String crumb, boolean allowVars) {
        this.validateUrl(value, results, required, crumb, allowVars, Severity.ERROR);
    }

    public void validateUrl(String value, ValidationResults results, boolean required, String crumb, boolean allowVars, Severity severity) {
        this.validateString(value, results, required, (Pattern)null, crumb);
        if (value != null) {
            this.checkUrl(value, results, allowVars, severity, crumb);
        }
    }

    public void validateEmail(String value, ValidationResults results, boolean required, String crumb) {
        this.validateString(value, results, required, (Pattern)null, crumb);
        if (value != null) {
            this.checkEmail(value, results, crumb);
        }
    }

    public <N extends Number> void validatePositive(N value, ValidationResults results, boolean required, String crumb) {
        this.checkMissing(required, value, results, crumb);
        if (value != null && NumericUtils.le(value, NumericUtils.zero(value))) {
            results.addError(Messages.m.msg("ReqPositive|Value must be strictly positive", crumb, value), crumb);
        }
    }

    public <N extends Number> void validateNonNegative(N value, ValidationResults results, boolean required, String crumb) {
        this.checkMissing(required, value, results, crumb);
        if (value != null && NumericUtils.lt(value, NumericUtils.zero(value))) {
            results.addError(Messages.m.msg("ReqPositive|Value must be strictly positive", crumb, value), crumb);
        }
    }

    public void validateNonEmpty(Collection<?> values, boolean hasValues, ValidationResults results, String crumb) {
        if (hasValues && values.isEmpty()) {
            results.addError(Messages.m.msg("EmptyColl|Collection may not be empty", new Object[0]), crumb);
        }
    }

    public <V> void validateUnique(final Collection<V> values, final ValidationResults results, final String crumb) {
        results.withCrumb(crumb, new Runnable(){
            Set<V> seen = Sets.newHashSet();

            @Override
            public void run() {
                int i = 0;
                for (Object value : values) {
                    if (this.seen.contains(value)) {
                        results.addError(Messages.m.msg("DuplicateValue|Value appeared already", value, crumb), "[" + i + "]");
                    } else {
                        this.seen.add(value);
                    }
                    ++i;
                }
            }
        });
    }

    public void validatePattern(String pattern, ValidationResults results, boolean required, String crumb) {
        this.checkMissing(required, pattern, results, crumb);
        if (pattern != null) {
            try {
                Pattern.compile(pattern);
            }
            catch (PatternSyntaxException e) {
                results.addWarning(Messages.m.msg("BadPattern|Pattern is not a valid Java Regular Expression but may be valid ECMA 262", pattern), crumb);
            }
        }
    }

    public <F> void validateField(F value, ValidationResults results, boolean required, String crumb, Validator<F> validator) {
        this.checkMissing(required, value, results, crumb);
        if (this.isPresent(value)) {
            validator.validate(value, results, crumb);
        }
    }

    public <V> void validateList(Collection<? extends V> value, boolean isPresent, ValidationResults results, boolean required, String crumb, Validator<V> validator) {
        if (required && !isPresent) {
            results.addError(Messages.m.msg("MissingField|Required field is missing", crumb), crumb);
        }
        if (isPresent && validator != null) {
            int i = 0;
            for (V element : value) {
                validator.validate(element, results, "[" + i++ + "]");
            }
        }
    }

    public <V> void validateMap(final Map<String, ? extends V> value, final ValidationResults results, boolean required, String crumb, final Pattern pattern, final Validator<V> validator) {
        this.checkMissing(required, value, results, crumb);
        results.withCrumb(crumb, new Runnable(){

            @Override
            public void run() {
                for (Map.Entry entry : value.entrySet()) {
                    ValidatorBase.this.checkKey((String)entry.getKey(), pattern, results);
                    if (validator == null) continue;
                    validator.validate(entry.getValue(), results, (String)entry.getKey());
                }
            }
        });
    }

    public void validateExtensions(Map<String, Object> extensions, ValidationResults results) {
        this.validateExtensions(extensions, results, null);
    }

    public void validateExtensions(Map<String, Object> extensions, ValidationResults results, String crumb) {
        this.validateMap(extensions, results, false, crumb, null, null);
    }

    public void validateFormat(String format, String type, ValidationResults results, String crumb) {
        if (format != null && type != null) {
            String normalType = null;
            switch (format) {
                case "int32": 
                case "int64": {
                    normalType = "integer";
                    break;
                }
                case "float": 
                case "double": {
                    normalType = "number";
                    break;
                }
                case "byte": 
                case "binary": 
                case "date": 
                case "date-time": 
                case "password": {
                    normalType = "string";
                }
            }
            if (normalType != null && !type.equals(normalType)) {
                results.addWarning(Messages.m.msg("WrongTypeFormat|OpenAPI-defined format used with nonstandard type", format, type, normalType), crumb);
            }
        }
    }

    public void validateDefault(Object defaultValue, String type, ValidationResults results, String crumb) {
        if (defaultValue != null && type != null) {
            boolean ok = false;
            switch (type) {
                case "string": {
                    ok = defaultValue instanceof String;
                    break;
                }
                case "number": {
                    ok = NumericUtils.isNumeric(defaultValue);
                    break;
                }
                case "integer": {
                    ok = NumericUtils.isIntegral(defaultValue);
                    break;
                }
                case "boolean": {
                    ok = defaultValue instanceof Boolean;
                    break;
                }
                case "object": {
                    ok = defaultValue instanceof Map;
                    break;
                }
                case "array": {
                    ok = defaultValue instanceof Collection;
                }
            }
            if (!ok) {
                results.addError(Messages.m.msg("WrongTypeValue|Value is incompatible with schema type", type, defaultValue), crumb);
            }
        }
    }

    private void checkMissing(boolean required, Object value, ValidationResults results, String crumb) {
        if (required && !this.isPresent(value)) {
            results.addError(Messages.m.msg("MissingField|Required field is missing", crumb), crumb);
        }
    }

    private void checkKey(String key, Pattern pattern, ValidationResults results) {
        if (pattern != null && !pattern.matcher(key).matches()) {
            results.addError(Messages.m.msg("BadKey|Invalid key in map", key, pattern), key);
        }
    }

    private void checkUrl(String url, ValidationResults results, boolean allowVars, Severity severity, String crumb) {
        String origUrl = url;
        if (allowVars && (url = url.replaceAll("\\{[^}]+\\}", "1")).startsWith("1:")) {
            url = SPECIAL_SCHEME + url.substring(1);
            if (!specialSchemeInited) {
                this.initSpecialScheme();
            }
        }
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            results.addError(Messages.m.msg("BadUrl|Invalid URL", origUrl, e.toString()), crumb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSpecialScheme() {
        String prop = "java.protocol.handler.pkgs";
        String former = System.getProperty(prop);
        try {
            System.setProperty(prop, ValidatorBase.class.getPackage().getName());
            new URL(SPECIAL_SCHEME + ":");
        }
        catch (MalformedURLException malformedURLException) {
        }
        finally {
            if (former != null) {
                System.setProperty(prop, former);
            } else {
                System.getProperties().remove(prop);
            }
        }
        specialSchemeInited = true;
    }

    private void checkEmail(String email, ValidationResults results, String crumb) {
        try {
            InternetAddress addr = new InternetAddress();
            addr.setAddress(email);
            addr.validate();
        }
        catch (AddressException e) {
            results.addError(Messages.m.msg("BadEmail|Invalid email address", email, e.toString()), crumb);
        }
    }

    private boolean isPresent(Object value) {
        return value instanceof JsonOverlay ? ((JsonOverlay)value).isPresent() : value != null;
    }
}

