/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.val3;

import com.google.inject.Inject;
import com.reprezen.kaizen.oasparser.model3.Header;
import com.reprezen.kaizen.oasparser.model3.MediaType;
import com.reprezen.kaizen.oasparser.model3.OpenApiObject;
import com.reprezen.kaizen.oasparser.model3.Path;
import com.reprezen.kaizen.oasparser.model3.Schema;
import com.reprezen.kaizen.oasparser.val.Messages;
import com.reprezen.kaizen.oasparser.val.ObjectValidatorBase;
import com.reprezen.kaizen.oasparser.val.ValidationResults;
import com.reprezen.kaizen.oasparser.val.Validator;
import com.reprezen.kaizen.oasparser.val3.Regexes;

public class HeaderValidator
extends ObjectValidatorBase<Header> {
    @Inject
    private Validator<Schema> schemaValidator;
    @Inject
    private Validator<MediaType> mediaTypeValidator;

    @Override
    public void validateObject(Header header, ValidationResults results) {
        this.validateString(header.getName(false), results, false, "name");
        this.validateString(header.getIn(false), results, false, Regexes.PARAM_IN_REGEX, "in");
        this.checkPathParam(header, results);
        this.checkRequired(header, results);
        this.validateString(header.getStyle(false), results, false, Regexes.STYLE_REGEX, "style");
        this.checkAllowReserved(header, results);
        this.validateField(header.getSchema(false), results, false, "schema", this.schemaValidator);
        this.validateMap(header.getContentMediaTypes(false), results, false, "content", Regexes.NOEXT_REGEX, this.mediaTypeValidator);
        this.validateExtensions(header.getExtensions(false), results);
    }

    private void checkPathParam(Header header, ValidationResults results) {
        if (header.getIn(false) != null && header.getIn(false).equals("path") && header.getName(false) != null) {
            String path = this.getPathString(header);
            if (path != null) {
                if (!path.matches(".*/\\{" + header.getName(false) + "\\}(/.*)?")) {
                    results.addError(Messages.m.msg("MissingPathTplt|No template for path parameter in path string", header.getName(false), path), "name");
                }
            } else {
                results.addWarning(Messages.m.msg("NoPath|Could not locate path for parameter", header.getName(false), header.getIn(false)));
            }
        }
    }

    private void checkRequired(Header header, ValidationResults results) {
        if ("path".equals(header.getIn(false)) && header.getRequired(false) != Boolean.TRUE) {
            results.addError(Messages.m.msg("PathParamReq|Path param must have 'required' property set true", header.getName(false)), "required");
        }
    }

    private void checkAllowReserved(Header header, ValidationResults results) {
        if (header.isAllowReserved() && !"query".equals(header.getIn(false))) {
            results.addWarning(Messages.m.msg("NonQryAllowRsvd|AllowReserved is ignored for non-query parameter", header.getName(false), header.getIn(false)), "allowReserved");
        }
    }

    private String getPathString(Header header) {
        OpenApiObject parent;
        for (parent = (OpenApiObject)header.getParentObject(); parent != null && !(parent instanceof Path); parent = (OpenApiObject)parent.getParentObject()) {
        }
        return parent instanceof Path ? parent.getPathInParent() : null;
    }
}

