/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.val3;

import com.google.inject.Inject;
import com.reprezen.kaizen.oasparser.model3.EncodingProperty;
import com.reprezen.kaizen.oasparser.model3.Example;
import com.reprezen.kaizen.oasparser.model3.MediaType;
import com.reprezen.kaizen.oasparser.model3.Schema;
import com.reprezen.kaizen.oasparser.val.Messages;
import com.reprezen.kaizen.oasparser.val.ObjectValidatorBase;
import com.reprezen.kaizen.oasparser.val.ValidationResults;
import com.reprezen.kaizen.oasparser.val.Validator;
import com.reprezen.kaizen.oasparser.val3.Regexes;
import java.util.Set;

public class MediaTypeValidator
extends ObjectValidatorBase<MediaType> {
    @Inject
    private Validator<Schema> schemaValidator;
    @Inject
    private Validator<EncodingProperty> encodingPropertyValidator;
    @Inject
    private Validator<Example> exampleValidator;

    @Override
    public void validateObject(MediaType mediaType, ValidationResults results) {
        this.validateField(mediaType.getSchema(false), results, false, "schema", this.schemaValidator);
        this.validateMap(mediaType.getEncodingProperties(false), results, false, "encoding", Regexes.NOEXT_NAME_REGEX, this.encodingPropertyValidator);
        this.checkEncodingPropsAreProps(mediaType, results);
        this.validateExtensions(mediaType.getExtensions(false), results);
        this.validateMap(mediaType.getExamples(false), results, false, "examples", Regexes.NOEXT_NAME_REGEX, this.exampleValidator);
    }

    void checkEncodingPropsAreProps(MediaType mediaType, ValidationResults results) {
        Schema schema = mediaType.getSchema(false);
        if (schema.isElaborated()) {
            Set<String> propNames = schema.getProperties(false).keySet();
            for (String encodingPropertyName : mediaType.getEncodingProperties(false).keySet()) {
                if (propNames.contains(encodingPropertyName)) continue;
                results.addError(Messages.m.msg("EncPropNotSchemaProp|Encoding property does not name a schema property for the media type", encodingPropertyName), encodingPropertyName);
            }
        }
    }
}

