/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.val3;

import com.google.inject.Inject;
import com.reprezen.kaizen.oasparser.model3.Callback;
import com.reprezen.kaizen.oasparser.model3.ExternalDocs;
import com.reprezen.kaizen.oasparser.model3.Header;
import com.reprezen.kaizen.oasparser.model3.Info;
import com.reprezen.kaizen.oasparser.model3.Link;
import com.reprezen.kaizen.oasparser.model3.OpenApi3;
import com.reprezen.kaizen.oasparser.model3.Parameter;
import com.reprezen.kaizen.oasparser.model3.Path;
import com.reprezen.kaizen.oasparser.model3.RequestBody;
import com.reprezen.kaizen.oasparser.model3.Response;
import com.reprezen.kaizen.oasparser.model3.Schema;
import com.reprezen.kaizen.oasparser.model3.SecurityRequirement;
import com.reprezen.kaizen.oasparser.model3.SecurityScheme;
import com.reprezen.kaizen.oasparser.model3.Server;
import com.reprezen.kaizen.oasparser.model3.Tag;
import com.reprezen.kaizen.oasparser.val.ObjectValidatorBase;
import com.reprezen.kaizen.oasparser.val.ValidationResults;
import com.reprezen.kaizen.oasparser.val.Validator;
import com.reprezen.kaizen.oasparser.val3.Regexes;

public class OpenApi3Validator
extends ObjectValidatorBase<OpenApi3> {
    @Inject
    private Validator<Info> infoValidator;
    @Inject
    private Validator<Server> serverValidator;
    @Inject
    private Validator<Path> pathValidator;
    @Inject
    private Validator<Schema> schemaValidator;
    @Inject
    private Validator<Response> responseValidator;
    @Inject
    private Validator<Parameter> parameterValidator;
    @Inject
    private Validator<RequestBody> requestBodyValidator;
    @Inject
    private Validator<Header> headerValidator;
    @Inject
    private Validator<SecurityScheme> securitySchemeValidator;
    @Inject
    private Validator<Link> linkValidator;
    @Inject
    private Validator<Callback> callbackValidator;
    @Inject
    private Validator<SecurityRequirement> securityRequirementValidator;
    @Inject
    private Validator<Tag> tagValidator;
    @Inject
    private Validator<ExternalDocs> externalDocsValidator;

    @Override
    public void validateObject(final OpenApi3 swagger, final ValidationResults results) {
        results.withCrumb("model", new Runnable(){

            @Override
            public void run() {
                OpenApi3Validator.this.validateString(swagger.getOpenApi(false), results, true, "3\\.\\d+(\\.\\d+.*)?", "openapi");
                OpenApi3Validator.this.validateField(swagger.getInfo(false), results, true, "info", OpenApi3Validator.this.infoValidator);
                OpenApi3Validator.this.validateList(swagger.getServers(false), swagger.hasServers(), results, false, "servers", OpenApi3Validator.this.serverValidator);
                OpenApi3Validator.this.validateMap(swagger.getPaths(false), results, true, "paths", Regexes.PATH_REGEX, OpenApi3Validator.this.pathValidator);
                OpenApi3Validator.this.validateMap(swagger.getPathsExtensions(false), results, false, "paths", Regexes.EXT_REGEX, null);
                OpenApi3Validator.this.validateMap(swagger.getSchemas(false), results, false, "collections/schemas", Regexes.NAME_REGEX, OpenApi3Validator.this.schemaValidator);
                OpenApi3Validator.this.validateMap(swagger.getResponses(false), results, false, "collections/responses", Regexes.NAME_REGEX, OpenApi3Validator.this.responseValidator);
                OpenApi3Validator.this.validateMap(swagger.getParameters(false), results, false, "collections/parameters", Regexes.NAME_REGEX, OpenApi3Validator.this.parameterValidator);
                OpenApi3Validator.this.validateMap(swagger.getExamples(false), results, false, "collections/examples", Regexes.NAME_REGEX, null);
                OpenApi3Validator.this.validateMap(swagger.getRequestBodies(false), results, false, "collection/requestBodies", Regexes.NAME_REGEX, OpenApi3Validator.this.requestBodyValidator);
                OpenApi3Validator.this.validateMap(swagger.getHeaders(false), results, false, "collections/headers", Regexes.NAME_REGEX, OpenApi3Validator.this.headerValidator);
                OpenApi3Validator.this.validateMap(swagger.getSecuritySchemes(false), results, false, "collections/securitySchemes", Regexes.NAME_REGEX, OpenApi3Validator.this.securitySchemeValidator);
                OpenApi3Validator.this.validateMap(swagger.getLinks(false), results, false, "collections/links", Regexes.NAME_REGEX, OpenApi3Validator.this.linkValidator);
                OpenApi3Validator.this.validateMap(swagger.getCallbacks(false), results, false, "collections/callbacks", Regexes.NAME_REGEX, OpenApi3Validator.this.callbackValidator);
                OpenApi3Validator.this.validateMap(swagger.getComponentsExtensions(false), results, false, "collections", Regexes.EXT_REGEX, null);
                OpenApi3Validator.this.validateList(swagger.getSecurityRequirements(false), swagger.hasSecurityRequirements(), results, false, "security", OpenApi3Validator.this.securityRequirementValidator);
                OpenApi3Validator.this.validateList(swagger.getTags(false), swagger.hasTags(), results, false, "tags", OpenApi3Validator.this.tagValidator);
                OpenApi3Validator.this.validateField(swagger.getExternalDocs(false), results, false, "externalDocs", OpenApi3Validator.this.externalDocsValidator);
                OpenApi3Validator.this.validateExtensions(swagger.getExtensions(false), results);
            }
        });
    }
}

