/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.val3;

import com.google.inject.Inject;
import com.reprezen.kaizen.oasparser.model3.MediaType;
import com.reprezen.kaizen.oasparser.model3.OpenApiObject;
import com.reprezen.kaizen.oasparser.model3.Parameter;
import com.reprezen.kaizen.oasparser.model3.Path;
import com.reprezen.kaizen.oasparser.model3.Schema;
import com.reprezen.kaizen.oasparser.val.Messages;
import com.reprezen.kaizen.oasparser.val.ObjectValidatorBase;
import com.reprezen.kaizen.oasparser.val.ValidationResults;
import com.reprezen.kaizen.oasparser.val.Validator;
import com.reprezen.kaizen.oasparser.val3.Regexes;

public class ParameterValidator
extends ObjectValidatorBase<Parameter> {
    @Inject
    private Validator<Schema> schemaValidator;
    @Inject
    private Validator<MediaType> mediaTypeValidator;

    @Override
    public void validateObject(Parameter parameter, ValidationResults results) {
        this.validateString(parameter.getName(false), results, true, "name");
        this.validateString(parameter.getIn(false), results, true, Regexes.PARAM_IN_REGEX, "in");
        this.checkPathParam(parameter, results);
        this.checkRequired(parameter, results);
        this.validateString(parameter.getStyle(false), results, false, Regexes.STYLE_REGEX, "style");
        this.checkAllowReserved(parameter, results);
        this.validateField(parameter.getSchema(false), results, false, "schema", this.schemaValidator);
        this.validateMap(parameter.getContentMediaTypes(false), results, false, "content", Regexes.NOEXT_REGEX, this.mediaTypeValidator);
        this.validateExtensions(parameter.getExtensions(false), results);
    }

    private void checkPathParam(Parameter parameter, ValidationResults results) {
        if (parameter.getIn(false) != null && parameter.getIn(false).equals("path") && parameter.getName(false) != null) {
            String path = this.getPathString(parameter);
            if (path != null) {
                if (!path.matches(".*/\\{" + parameter.getName(false) + "\\}(/.*)?")) {
                    results.addError(Messages.m.msg("MissingPathTplt|No template for path parameter in path string", parameter.getName(false), path), "name");
                }
            } else {
                results.addWarning(Messages.m.msg("NoPath|Could not locate path for parameter", parameter.getName(false), parameter.getIn(false)));
            }
        }
    }

    private void checkRequired(Parameter parameter, ValidationResults results) {
        if ("path".equals(parameter.getIn(false)) && parameter.getRequired(false) != Boolean.TRUE) {
            results.addError(Messages.m.msg("PathParamReq|Path param must have 'required' property set true", parameter.getName(false)), "required");
        }
    }

    private void checkAllowReserved(Parameter parameter, ValidationResults results) {
        if (parameter.isAllowReserved() && !"query".equals(parameter.getIn(false))) {
            results.addWarning(Messages.m.msg("NonQryAllowRsvd|AllowReserved is ignored for non-query parameter", parameter.getName(false), parameter.getIn(false)), "allowReserved");
        }
    }

    private String getPathString(Parameter parameter) {
        OpenApiObject parent;
        for (parent = (OpenApiObject)parameter.getParentObject(); parent != null && !(parent instanceof Path); parent = (OpenApiObject)parent.getParentObject()) {
        }
        return parent instanceof Path ? parent.getPathInParent() : null;
    }
}

