/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.val3;

import com.google.inject.Inject;
import com.reprezen.kaizen.oasparser.model3.Example;
import com.reprezen.kaizen.oasparser.model3.ExternalDocs;
import com.reprezen.kaizen.oasparser.model3.Schema;
import com.reprezen.kaizen.oasparser.model3.Xml;
import com.reprezen.kaizen.oasparser.val.Messages;
import com.reprezen.kaizen.oasparser.val.ObjectValidatorBase;
import com.reprezen.kaizen.oasparser.val.ValidationResults;
import com.reprezen.kaizen.oasparser.val.Validator;
import com.reprezen.kaizen.oasparser.val3.Regexes;

public class SchemaValidator
extends ObjectValidatorBase<Schema> {
    @Inject
    private Validator<Xml> xmlValidator;
    @Inject
    private Validator<ExternalDocs> externalDocsValidator;
    @Inject
    private Validator<Example> exampleValidator;

    @Override
    public void validateObject(Schema schema, ValidationResults results) {
        this.validatePositive(schema.getMultipleOf(false), results, false, "multipleOf");
        this.validateNonNegative(schema.getMaxLength(false), results, false, "maxLength");
        this.validateNonNegative(schema.getMinLength(false), results, false, "minLength");
        this.validatePattern(schema.getPattern(false), results, false, "pattern");
        this.validateNonNegative(schema.getMaximum(false), results, false, "maxItems");
        this.validateNonNegative(schema.getMaximum(false), results, false, "minItems");
        this.validateNonNegative(schema.getMaxProperties(false), results, false, "maxProperties");
        this.validateNonNegative(schema.getMinProperties(false), results, false, "minProperties");
        this.validateUnique(schema.getRequiredFields(false), results, "required");
        this.validateList(schema.getEnums(false), schema.hasEnums(), results, false, "enum", null);
        this.validateNonEmpty(schema.getEnums(false), schema.hasEnums(), results, "enum");
        this.validateUnique(schema.getEnums(false), results, "enum");
        this.validateString(schema.getType(false), results, false, "boolean|object|array|number|integer|string", "type");
        this.validateList(schema.getAllOfSchemas(false), schema.hasAllOfSchemas(), results, false, "allOf", this);
        this.validateList(schema.getOneOfSchemas(false), schema.hasOneOfSchemas(), results, false, "oneOf", this);
        this.validateList(schema.getAnyOfSchemas(false), schema.hasAnyOfSchemas(), results, false, "anyOf", this);
        if (schema.getNotSchema(false) != null && schema.getNotSchema(false).isPresent()) {
            this.validate(schema.getNotSchema(false), results, "not");
        }
        if (schema.getItemsSchema(false) != null && schema.getItemsSchema(false).isPresent()) {
            this.validate(schema.getItemsSchema(false), results, "items");
        }
        this.validateMap(schema.getProperties(false), results, false, "properties", Regexes.NOEXT_NAME_REGEX, this);
        this.validateFormat(schema.getFormat(false), schema.getType(false), results, "format");
        this.validateDefault(schema.getDefault(false), schema.getType(false), results, "default");
        this.checkDiscriminator(schema, results, "discriminator");
        this.checkReadWrite(schema, results);
        this.validateField(schema.getXml(false), results, false, "xml", this.xmlValidator);
        this.validateField(schema.getExternalDocs(false), results, false, "externalDocs", this.externalDocsValidator);
        this.validateMap(schema.getExamples(false), results, false, "examples", Regexes.NOEXT_NAME_REGEX, this.exampleValidator);
        this.validateExtensions(schema.getExtensions(false), results);
    }

    private void checkDiscriminator(Schema schema, ValidationResults results, String crumb) {
        String discriminator = schema.getDiscriminator(false);
        if (discriminator != null) {
            if (!schema.getProperties(false).keySet().contains(discriminator)) {
                results.addError(Messages.m.msg("DiscNotProp|The discriminator is not a property of this schema", discriminator), crumb);
            }
            if (!schema.getRequiredFields(false).contains(discriminator)) {
                results.addError(Messages.m.msg("DiscNotReq|The discriminator property is not required in this schema", discriminator), crumb);
            }
        }
    }

    private void checkReadWrite(Schema schema, ValidationResults results) {
        if (schema.isReadOnly() && schema.isWriteOnly()) {
            results.addError(Messages.m.msg("ROnlyAndWOnly|Schema cannot be both ReadOnly and WriteOnly", new Object[0]));
        }
    }
}

