/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.val3;

import com.google.inject.Inject;
import com.reprezen.kaizen.oasparser.model3.OAuthFlow;
import com.reprezen.kaizen.oasparser.model3.SecurityScheme;
import com.reprezen.kaizen.oasparser.val.ObjectValidatorBase;
import com.reprezen.kaizen.oasparser.val.ValidationResults;
import com.reprezen.kaizen.oasparser.val.Validator;

public class SecuritySchemeValidator
extends ObjectValidatorBase<SecurityScheme> {
    @Inject
    private Validator<OAuthFlow> oauthFlowValidator;

    @Override
    public void validateObject(SecurityScheme securityScheme, ValidationResults results) {
        this.validateString(securityScheme.getType(false), results, true, "apiKey|http|oauth2|openIdConnect", "type");
        switch (securityScheme.getType(false)) {
            case "http": {
                this.validateString(securityScheme.getScheme(false), results, true, "scheme");
                break;
            }
            case "apiKey": {
                this.validateString(securityScheme.getName(false), results, true, "name");
                this.validateString(securityScheme.getIn(false), results, true, "query|header|cookie", "in");
                break;
            }
            case "oauth2": {
                this.validateField(securityScheme.getImplicitOAuthFlow(false), results, false, "flow.implicit", this.oauthFlowValidator);
                this.validateField(securityScheme.getImplicitOAuthFlow(false), results, false, "flow.password", this.oauthFlowValidator);
                this.validateField(securityScheme.getImplicitOAuthFlow(false), results, false, "flow.clientCredentials", this.oauthFlowValidator);
                this.validateField(securityScheme.getImplicitOAuthFlow(false), results, false, "authorizationCode", this.oauthFlowValidator);
                this.validateExtensions(securityScheme.getOAuthFlowsExtensions(false), results, "flow");
                break;
            }
            case "openIdConnect": {
                this.validateUrl(securityScheme.getOpenIdConnectUrl(false), results, true, "openIdConnectUrl");
            }
        }
        this.validateExtensions(securityScheme.getExtensions(false), results);
    }
}

