/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.val3;

import com.reprezen.kaizen.oasparser.model3.Example;
import com.reprezen.kaizen.oasparser.model3.Header;
import com.reprezen.kaizen.oasparser.model3.MediaType;
import com.reprezen.kaizen.oasparser.model3.Schema;
import com.reprezen.kaizen.oasparser.val.ObjectValidatorBase;
import com.reprezen.kaizen.oasparser.val.msg.Messages;
import com.reprezen.kaizen.oasparser.val3.ExampleValidator;
import com.reprezen.kaizen.oasparser.val3.MediaTypeValidator;
import com.reprezen.kaizen.oasparser.val3.OpenApi3Messages;
import com.reprezen.kaizen.oasparser.val3.Regexes;
import com.reprezen.kaizen.oasparser.val3.SchemaValidator;
import java.util.function.Consumer;

public class HeaderValidator
extends ObjectValidatorBase<Header> {
    @Override
    public void runObjectValidations() {
        Header header = (Header)this.value.getOverlay();
        this.validateStringField("description", false);
        this.validateBooleanField("deprecated", false);
        this.validateBooleanField("allowEmptyValue", false);
        this.validateBooleanField("explode", false);
        this.validateField("example", false, Object.class, null, new Consumer[0]);
        this.validateMapField("examples", false, false, Example.class, new ExampleValidator());
        this.validateStringField("style", false, Regexes.STYLE_REGEX, new Consumer[0]);
        this.checkAllowReserved(header);
        this.validateField("schema", false, Schema.class, new SchemaValidator(), new Consumer[0]);
        this.validateMapField("contentMediaTypes", false, false, MediaType.class, new MediaTypeValidator());
        this.validateExtensions(header.getExtensions());
        this.checkContentType();
    }

    private void checkAllowReserved(Header header) {
        if (header.isAllowReserved()) {
            this.results.addWarning(Messages.msg(OpenApi3Messages.NonQryAllowRsvd, this.value.getPathInParent(), "header"), this.value);
        }
    }

    private void checkContentType() {
        if (this.value.getPathInParent().equalsIgnoreCase("Content-Type")) {
            this.results.addWarning(Messages.msg(OpenApi3Messages.IgnContType, new Object[0]), this.value);
        }
    }
}

