/*
 * Decompiled with CFR 0.152.
 */
package com.resend.services.audiences;

import com.resend.core.exception.ResendException;
import com.resend.core.net.AbstractHttpResponse;
import com.resend.core.net.HttpMethod;
import com.resend.core.service.BaseService;
import com.resend.services.audiences.model.CreateAudienceOptions;
import com.resend.services.audiences.model.CreateAudienceResponseSuccess;
import com.resend.services.audiences.model.GetAudienceResponseSuccess;
import com.resend.services.audiences.model.ListAudiencesResponseSuccess;
import com.resend.services.audiences.model.RemoveAudienceResponseSuccess;
import okhttp3.MediaType;

public class Audiences
extends BaseService {
    public Audiences(String apiKey) {
        super(apiKey);
    }

    public CreateAudienceResponseSuccess create(CreateAudienceOptions createAudienceOptions) throws ResendException {
        String payload = this.resendMapper.writeValue(createAudienceOptions);
        AbstractHttpResponse response = this.httpClient.perform("/audiences", this.apiKey, HttpMethod.POST, payload, MediaType.get((String)"application/json"));
        if (!response.isSuccessful()) {
            throw new ResendException("Failed to create Audience: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        return this.resendMapper.readValue(responseBody, CreateAudienceResponseSuccess.class);
    }

    public ListAudiencesResponseSuccess list() throws ResendException {
        AbstractHttpResponse response = this.httpClient.perform("/audiences", this.apiKey, HttpMethod.GET, null, MediaType.get((String)"application/json"));
        if (!response.isSuccessful()) {
            throw new ResendException("Failed to retrieve audiences: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        return this.resendMapper.readValue(responseBody, ListAudiencesResponseSuccess.class);
    }

    public GetAudienceResponseSuccess get(String id) throws ResendException {
        AbstractHttpResponse response = this.httpClient.perform("/audiences/" + id, this.apiKey, HttpMethod.GET, null, MediaType.get((String)"application/json"));
        if (!response.isSuccessful()) {
            throw new RuntimeException("Failed to retrieve audience: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        return this.resendMapper.readValue(responseBody, GetAudienceResponseSuccess.class);
    }

    public RemoveAudienceResponseSuccess remove(String id) throws ResendException {
        AbstractHttpResponse response = this.httpClient.perform("/audiences/" + id, this.apiKey, HttpMethod.DELETE, "", null);
        if (!response.isSuccessful()) {
            throw new ResendException("Failed to delete audience: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        return this.resendMapper.readValue(responseBody, RemoveAudienceResponseSuccess.class);
    }
}

