/*
 * Decompiled with CFR 0.152.
 */
package com.resend.services.broadcasts;

import com.resend.core.exception.ResendException;
import com.resend.core.net.AbstractHttpResponse;
import com.resend.core.net.HttpMethod;
import com.resend.core.service.BaseService;
import com.resend.services.broadcasts.model.CreateBroadcastOptions;
import com.resend.services.broadcasts.model.CreateBroadcastResponseSuccess;
import com.resend.services.broadcasts.model.GetBroadcastResponseSuccess;
import com.resend.services.broadcasts.model.ListBroadcastsResponseSuccess;
import com.resend.services.broadcasts.model.RemoveBroadcastResponseSuccess;
import com.resend.services.broadcasts.model.SendBroadcastOptions;
import com.resend.services.broadcasts.model.SendBroadcastResponseSuccess;
import com.resend.services.broadcasts.model.UpdateBroadcastOptions;
import com.resend.services.broadcasts.model.UpdateBroadcastResponseSuccess;
import okhttp3.MediaType;

public class Broadcasts
extends BaseService {
    public Broadcasts(String apiKey) {
        super(apiKey);
    }

    public CreateBroadcastResponseSuccess create(CreateBroadcastOptions createBroadcastOptions) throws ResendException {
        String payload = this.resendMapper.writeValue(createBroadcastOptions);
        AbstractHttpResponse response = this.httpClient.perform("/broadcasts", this.apiKey, HttpMethod.POST, payload, MediaType.get((String)"application/json"));
        if (!response.isSuccessful()) {
            throw new ResendException("Failed to create Broadcast: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        return this.resendMapper.readValue(responseBody, CreateBroadcastResponseSuccess.class);
    }

    public GetBroadcastResponseSuccess get(String id) throws ResendException {
        AbstractHttpResponse response = this.httpClient.perform("/broadcasts/" + id, this.apiKey, HttpMethod.GET, null, MediaType.get((String)"application/json"));
        if (!response.isSuccessful()) {
            throw new RuntimeException("Failed to retrieve broadcast: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        return this.resendMapper.readValue(responseBody, GetBroadcastResponseSuccess.class);
    }

    public SendBroadcastResponseSuccess send(SendBroadcastOptions sendBroadcastOptions, String broadcastId) throws ResendException {
        String payload = this.resendMapper.writeValue(sendBroadcastOptions);
        AbstractHttpResponse response = this.httpClient.perform("/broadcasts/" + broadcastId + "/send", this.apiKey, HttpMethod.POST, payload, MediaType.get((String)"application/json"));
        if (!response.isSuccessful()) {
            throw new ResendException("Failed to send broadcast: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        return this.resendMapper.readValue(responseBody, SendBroadcastResponseSuccess.class);
    }

    public RemoveBroadcastResponseSuccess remove(String id) throws ResendException {
        AbstractHttpResponse response = this.httpClient.perform("/broadcasts/" + id, this.apiKey, HttpMethod.DELETE, "", null);
        if (!response.isSuccessful()) {
            throw new ResendException("Failed to delete broadcast: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        return this.resendMapper.readValue(responseBody, RemoveBroadcastResponseSuccess.class);
    }

    public ListBroadcastsResponseSuccess list() throws ResendException {
        AbstractHttpResponse response = this.httpClient.perform("/broadcasts", this.apiKey, HttpMethod.GET, null, MediaType.get((String)"application/json"));
        if (!response.isSuccessful()) {
            throw new ResendException("Failed to retrieve broadcasts: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        return this.resendMapper.readValue(responseBody, ListBroadcastsResponseSuccess.class);
    }

    public UpdateBroadcastResponseSuccess update(UpdateBroadcastOptions updateBroadcastOptions) throws ResendException {
        String payload = this.resendMapper.writeValue(updateBroadcastOptions);
        AbstractHttpResponse response = this.httpClient.perform("/broadcasts/" + updateBroadcastOptions.getId(), this.apiKey, HttpMethod.PATCH, payload, MediaType.get((String)"application/json"));
        if (!response.isSuccessful()) {
            throw new ResendException("Failed to update Broadcast: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        return this.resendMapper.readValue(responseBody, UpdateBroadcastResponseSuccess.class);
    }
}

