/*
 * Decompiled with CFR 0.152.
 */
package com.resend.services.broadcasts.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BroadcastOptions {
    @JsonProperty(value="audience_id")
    private final String audienceId;
    @JsonProperty(value="from")
    private final String from;
    @JsonProperty(value="subject")
    private final String subject;
    @JsonProperty(value="reply_to")
    private final List<String> replyTo;
    @JsonProperty(value="html")
    private final String html;
    @JsonProperty(value="text")
    private final String text;
    @JsonProperty(value="name")
    private final String name;

    protected BroadcastOptions(Builder builder) {
        this.audienceId = builder.audienceId;
        this.from = builder.from;
        this.subject = builder.subject;
        this.replyTo = builder.replyTo;
        this.html = builder.html;
        this.text = builder.text;
        this.name = builder.name;
    }

    public String getAudienceId() {
        return this.audienceId;
    }

    public String getFrom() {
        return this.from;
    }

    public String getSubject() {
        return this.subject;
    }

    public List<String> getReplyTo() {
        return this.replyTo;
    }

    public String getHtml() {
        return this.html;
    }

    public String getText() {
        return this.text;
    }

    public String getName() {
        return this.name;
    }

    protected static abstract class Builder<T extends BroadcastOptions, B extends Builder<T, B>> {
        protected String audienceId;
        protected String from;
        protected String subject;
        protected List<String> replyTo;
        protected String html;
        protected String text;
        protected String name;

        protected Builder() {
        }

        public B audienceId(String audienceId) {
            this.audienceId = audienceId;
            return this.self();
        }

        public B from(String from) {
            this.from = from;
            return this.self();
        }

        public B subject(String subject) {
            this.subject = subject;
            return this.self();
        }

        public B replyTo(String ... replyTo) {
            if (this.replyTo == null) {
                this.replyTo = new ArrayList<String>();
            }
            this.replyTo.addAll(Arrays.asList(replyTo));
            return this.self();
        }

        public B replyTo(List<String> replyTo) {
            this.replyTo = replyTo;
            return this.self();
        }

        public B html(String html) {
            this.html = html;
            return this.self();
        }

        public B text(String text) {
            this.text = text;
            return this.self();
        }

        public B name(String name) {
            this.name = name;
            return this.self();
        }

        public abstract T build();

        protected abstract B self();
    }
}

