/*
 * Decompiled with CFR 0.152.
 */
package com.resend.services.contacts;

import com.resend.core.exception.ResendException;
import com.resend.core.net.AbstractHttpResponse;
import com.resend.core.net.HttpMethod;
import com.resend.core.service.BaseService;
import com.resend.services.contacts.model.CreateContactOptions;
import com.resend.services.contacts.model.CreateContactResponseSuccess;
import com.resend.services.contacts.model.GetContactOptions;
import com.resend.services.contacts.model.GetContactResponseSuccess;
import com.resend.services.contacts.model.ListContactsResponseSuccess;
import com.resend.services.contacts.model.RemoveContactOptions;
import com.resend.services.contacts.model.RemoveContactResponseSuccess;
import com.resend.services.contacts.model.UpdateContactOptions;
import com.resend.services.contacts.model.UpdateContactResponseSuccess;
import okhttp3.MediaType;

public class Contacts
extends BaseService {
    public Contacts(String apiKey) {
        super(apiKey);
    }

    public CreateContactResponseSuccess create(CreateContactOptions createContactOptions) throws ResendException {
        String payload = this.resendMapper.writeValue(createContactOptions);
        AbstractHttpResponse response = this.httpClient.perform("/audiences/" + createContactOptions.getAudienceId() + "/contacts", this.apiKey, HttpMethod.POST, payload, MediaType.get((String)"application/json"));
        if (!response.isSuccessful()) {
            throw new ResendException("Failed to create contact: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        return this.resendMapper.readValue(responseBody, CreateContactResponseSuccess.class);
    }

    public ListContactsResponseSuccess list(String audienceId) throws ResendException {
        AbstractHttpResponse response = this.httpClient.perform("/audiences/" + audienceId + "/contacts", this.apiKey, HttpMethod.GET, null, MediaType.get((String)"application/json"));
        if (!response.isSuccessful()) {
            throw new ResendException("Failed to retrieve contacts: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        return this.resendMapper.readValue(responseBody, ListContactsResponseSuccess.class);
    }

    public GetContactResponseSuccess get(GetContactOptions params) throws ResendException {
        AbstractHttpResponse response = this.httpClient.perform("/audiences/" + params.getAudienceId() + "/contacts/" + params.getId(), this.apiKey, HttpMethod.GET, null, MediaType.get((String)"application/json"));
        if (!response.isSuccessful()) {
            throw new RuntimeException("Failed to retrieve contact: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        return this.resendMapper.readValue(responseBody, GetContactResponseSuccess.class);
    }

    public RemoveContactResponseSuccess remove(RemoveContactOptions params) throws ResendException {
        if (params.getId() == null && params.getEmail() == null || params.getId() != null && params.getEmail() != null) {
            throw new IllegalArgumentException("Either 'id' or 'email' must be provided, but not both.");
        }
        String pathParameter = params.getId() != null ? params.getId() : params.getEmail();
        AbstractHttpResponse response = this.httpClient.perform("/audiences/" + params.getAudienceId() + "/contacts/" + pathParameter, this.apiKey, HttpMethod.DELETE, "", null);
        if (!response.isSuccessful()) {
            throw new ResendException("Failed to delete contact: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        return this.resendMapper.readValue(responseBody, RemoveContactResponseSuccess.class);
    }

    public UpdateContactResponseSuccess update(UpdateContactOptions params) throws ResendException {
        if (params.getId() == null && params.getEmail() == null || params.getId() != null && params.getEmail() != null) {
            throw new IllegalArgumentException("Either 'id' or 'email' must be provided, but not both.");
        }
        String pathParameter = params.getId() != null ? params.getId() : params.getEmail();
        String payload = this.resendMapper.writeValue(params);
        AbstractHttpResponse response = this.httpClient.perform("/audiences/" + params.getAudienceId() + "/contacts/" + pathParameter, this.apiKey, HttpMethod.PATCH, payload, MediaType.get((String)"application/json"));
        if (!response.isSuccessful()) {
            throw new ResendException("Failed to patch contact: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        return this.resendMapper.readValue(responseBody, UpdateContactResponseSuccess.class);
    }
}

