/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.restfuse;

import com.eclipsesource.restfuse.Response;
import com.eclipsesource.restfuse.Status;

public final class Assert {
    public static void assertContinue(Response response) {
        Assert.doCheckStatus(Status.CONTINUE, response);
    }

    public static void assertSwitchingProtocols(Response response) {
        Assert.doCheckStatus(Status.SWITCHING_PROTOCOLS, response);
    }

    public static void assertOk(Response response) {
        Assert.doCheckStatus(Status.OK, response);
    }

    public static void assertCreated(Response response) {
        Assert.doCheckStatus(Status.CREATED, response);
    }

    public static void assertAccepted(Response response) {
        Assert.doCheckStatus(Status.ACCEPTED, response);
    }

    public static void assertNonAuthoritativeInformation(Response response) {
        Assert.doCheckStatus(Status.NON_AUTHORITATIVE_INFORMATION, response);
    }

    public static void assertNoContent(Response response) {
        Assert.doCheckStatus(Status.NO_CONTENT, response);
    }

    public static void assertResetContent(Response response) {
        Assert.doCheckStatus(Status.RESET_CONTENT, response);
    }

    public static void assertPartialContent(Response response) {
        Assert.doCheckStatus(Status.PARTIAL_CONTENT, response);
    }

    public static void assertMultipleChoices(Response response) {
        Assert.doCheckStatus(Status.MULTIPLE_CHOICES, response);
    }

    public static void assertMovedPermanently(Response response) {
        Assert.doCheckStatus(Status.MOVED_PERMANENTLY, response);
    }

    public static void assertFound(Response response) {
        Assert.doCheckStatus(Status.FOUND, response);
    }

    public static void assertSeeOther(Response response) {
        Assert.doCheckStatus(Status.SEE_OTHER, response);
    }

    public static void assertNotModified(Response response) {
        Assert.doCheckStatus(Status.NOT_MODIFIED, response);
    }

    public static void assertUseProxy(Response response) {
        Assert.doCheckStatus(Status.USE_PROXY, response);
    }

    public static void assertTemporaryRedirected(Response response) {
        Assert.doCheckStatus(Status.TEMPORARY_REDIRECT, response);
    }

    public static void assertBadRequest(Response response) {
        Assert.doCheckStatus(Status.BAD_REQUEST, response);
    }

    public static void assertUnauthorized(Response response) {
        Assert.doCheckStatus(Status.UNAUTHORIZED, response);
    }

    public static void assertPaymentRequired(Response response) {
        Assert.doCheckStatus(Status.PAYMENT_REQUIRED, response);
    }

    public static void assertForbidden(Response response) {
        Assert.doCheckStatus(Status.FORBIDDEN, response);
    }

    public static void assertNotFound(Response response) {
        Assert.doCheckStatus(Status.NOT_FOUND, response);
    }

    public static void assertMethodNotAllowed(Response response) {
        Assert.doCheckStatus(Status.METHOD_NOT_ALLOWED, response);
    }

    public static void assertNotAcceptable(Response response) {
        Assert.doCheckStatus(Status.NOT_ACCEPTABLE, response);
    }

    public static void assertProxyAuthenticationRequired(Response response) {
        Assert.doCheckStatus(Status.PROXY_AUTHENTICATION_REQUIRED, response);
    }

    public static void assertRequestTimeout(Response response) {
        Assert.doCheckStatus(Status.REQUEST_TIMEOUT, response);
    }

    public static void assertConflict(Response response) {
        Assert.doCheckStatus(Status.CONFLICT, response);
    }

    public static void assertGone(Response response) {
        Assert.doCheckStatus(Status.GONE, response);
    }

    public static void assertLengthRequired(Response response) {
        Assert.doCheckStatus(Status.LENGTH_REQUIRED, response);
    }

    public static void assertPreconditionFailed(Response response) {
        Assert.doCheckStatus(Status.PRECONDITION_FAILED, response);
    }

    public static void assertRequestEntityTooLarge(Response response) {
        Assert.doCheckStatus(Status.REQUEST_ENTITY_TOO_LARGE, response);
    }

    public static void assertRequestURITooLong(Response response) {
        Assert.doCheckStatus(Status.REQUEST_URI_TOO_LONG, response);
    }

    public static void assertUnsupportedMediaType(Response response) {
        Assert.doCheckStatus(Status.UNSUPPORTED_MEDIA_TYPE, response);
    }

    public static void assertRequestedRangeNotSatisfiable(Response response) {
        Assert.doCheckStatus(Status.REQUEST_RANGE_NOT_SATISFIABLE, response);
    }

    public static void assertExpectationFailed(Response response) {
        Assert.doCheckStatus(Status.EXPECTATION_FAILED, response);
    }

    public static void assertInternalServerError(Response response) {
        Assert.doCheckStatus(Status.INTERNAL_SERVER_ERROR, response);
    }

    public static void assertNotImplemented(Response response) {
        Assert.doCheckStatus(Status.NOT_IMPLEMENTED, response);
    }

    public static void assertBadGateway(Response response) {
        Assert.doCheckStatus(Status.BAD_GATEWAY, response);
    }

    public static void assertServiceUnavailable(Response response) {
        Assert.doCheckStatus(Status.SERVICE_UNAVAILABLE, response);
    }

    public static void assertGatewayTimeout(Response response) {
        Assert.doCheckStatus(Status.GATEWAY_TIMEOUT, response);
    }

    public static void assertHTTPVersionNotSupported(Response response) {
        Assert.doCheckStatus(Status.HTTP_VERSION_NOT_SUPPORTED, response);
    }

    private static void doCheckStatus(Status expected, Response response) {
        Assert.assertStatusEquals(Assert.getDetailedErrorMessage(expected, response), expected.getStatusCode(), response.getStatus());
    }

    private static void assertStatusEquals(String detailedErrorMessage, int expected, int actual) {
        if (expected != actual) {
            org.junit.Assert.fail((String)detailedErrorMessage);
        }
    }

    private static String getDetailedErrorMessage(Status expected, Response response) {
        StringBuilder builder = new StringBuilder();
        builder.append("Sent request to " + response.getUrl());
        builder.append("\n");
        builder.append("Response code did mot match expectation:");
        builder.append("\n");
        builder.append("Expected " + expected.getStatusCode() + " (" + expected.toString() + ") ");
        builder.append("but was " + response.getStatus());
        builder.append(" (" + (Object)((Object)Status.forStatusCode(response.getStatus())) + ")");
        builder.append("\n\n");
        return builder.toString();
    }

    private Assert() {
    }
}

