/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.restfuse;

import com.eclipsesource.restfuse.RequestContext;
import com.eclipsesource.restfuse.annotation.HttpTest;
import com.eclipsesource.restfuse.internal.HttpTestStatement;
import java.net.MalformedURLException;
import java.net.URL;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class Destination
implements TestRule {
    private HttpTestStatement requestStatement;
    private final String baseUrl;
    private String proxyHost;
    private int proxyPort;
    private RequestContext context;
    private Object testObject;

    public Destination(Object testObject, String baseUrl) {
        this.checkBaseUrl(baseUrl);
        this.checkTestObject(testObject);
        this.testObject = testObject;
        this.baseUrl = baseUrl;
        this.context = new RequestContext();
    }

    public Destination(Object testObject, String baseUrl, String proxyHost, int proxyPort) {
        this(testObject, baseUrl);
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.context = new RequestContext();
    }

    public RequestContext getRequestContext() {
        return this.context;
    }

    private void checkBaseUrl(String baseUrl) {
        if (baseUrl == null) {
            throw new IllegalArgumentException("baseUrl must not be null");
        }
        try {
            new URL(baseUrl);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("baseUrl has to be an URL");
        }
    }

    private void checkTestObject(Object testObject) {
        if (testObject == null) {
            throw new IllegalArgumentException("testObject must not be null.");
        }
    }

    public Statement apply(Statement base, Description description) {
        Statement result;
        if (this.hasAnnotation(description)) {
            this.requestStatement = new HttpTestStatement(base, description, this.testObject, this.baseUrl, this.proxyHost, this.proxyPort, this.context);
            result = this.requestStatement;
        } else {
            result = base;
        }
        return result;
    }

    private boolean hasAnnotation(Description description) {
        return description.getAnnotation(HttpTest.class) != null;
    }
}

