/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.restfuse.internal;

import com.eclipsesource.restfuse.Method;
import com.eclipsesource.restfuse.RequestContext;
import com.eclipsesource.restfuse.Response;
import com.eclipsesource.restfuse.annotation.Callback;
import com.eclipsesource.restfuse.annotation.Context;
import com.eclipsesource.restfuse.annotation.HttpTest;
import com.eclipsesource.restfuse.annotation.Poll;
import com.eclipsesource.restfuse.internal.BasicStatement;
import com.eclipsesource.restfuse.internal.InternalRequest;
import com.eclipsesource.restfuse.internal.RequestConfiguration;
import com.eclipsesource.restfuse.internal.callback.CallbackStatement;
import com.eclipsesource.restfuse.internal.poll.PollStatement;
import java.lang.reflect.Field;
import java.util.Properties;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class HttpTestStatement
extends Statement {
    static final String HTTP_PROXY_HOST = "http.proxyHost";
    static final String HTTP_PROXY_PORT = "http.proxyPort";
    private final Statement base;
    private final Description description;
    private final Object target;
    private final String baseUrl;
    private final String proxyHost;
    private final int proxyPort;
    private final RequestContext context;

    public HttpTestStatement(Statement base, Description description, Object target, String baseUrl, String proxyHost, int proxyPort, RequestContext context) {
        this.base = base;
        this.description = description;
        this.target = target;
        this.baseUrl = baseUrl;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.context = context;
    }

    public void evaluate() throws Throwable {
        this.setProxyProperties();
        try {
            this.doEvaluate();
        }
        finally {
            this.unsetProxyProperties();
        }
    }

    private void setProxyProperties() {
        if (this.proxyHost != null) {
            System.setProperty(HTTP_PROXY_HOST, this.proxyHost);
            System.setProperty(HTTP_PROXY_PORT, String.valueOf(this.proxyPort));
        }
    }

    private void doEvaluate() throws Throwable {
        Statement delegate = new BasicStatement(this.base, this);
        if (this.needsCallback()) {
            delegate = new CallbackStatement(this.base, this, this.description, this.target);
        } else if (this.needsPoll()) {
            delegate = new PollStatement(this.base, this, this.description, this.target);
        }
        delegate.evaluate();
    }

    private void unsetProxyProperties() {
        Properties properties = System.getProperties();
        properties.remove(HTTP_PROXY_HOST);
        properties.remove(HTTP_PROXY_PORT);
    }

    private boolean needsCallback() {
        Callback callbackAnnotation = (Callback)this.description.getAnnotation(Callback.class);
        return callbackAnnotation != null;
    }

    private boolean needsPoll() {
        Poll pollAnnotation = (Poll)this.description.getAnnotation(Poll.class);
        return pollAnnotation != null;
    }

    public Response sendRequest() {
        InternalRequest request = this.buildRequest();
        return this.callService(request);
    }

    private InternalRequest buildRequest() {
        RequestConfiguration requestConfiguration = new RequestConfiguration(this.baseUrl, this.description, this.target);
        return requestConfiguration.createRequest(this.context);
    }

    private Response callService(InternalRequest request) {
        Method requestMethod = ((HttpTest)this.description.getAnnotation(HttpTest.class)).method();
        Response result = null;
        if (requestMethod.equals((Object)Method.GET)) {
            result = request.get();
        } else if (requestMethod.equals((Object)Method.POST)) {
            result = request.post();
        } else if (requestMethod.equals((Object)Method.DELETE)) {
            result = request.delete();
        } else if (requestMethod.equals((Object)Method.PUT)) {
            result = request.put();
        } else if (requestMethod.equals((Object)Method.HEAD)) {
            result = request.head();
        } else if (requestMethod.equals((Object)Method.OPTIONS)) {
            result = request.options();
        }
        return result;
    }

    public void tryInjectResponse(Response response) {
        Field[] fields;
        Field[] fieldArray = fields = this.target.getClass().getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Context contextAnnotation = field.getAnnotation(Context.class);
            if (contextAnnotation != null && field.getType() == Response.class) {
                this.injectResponse(field, response);
            }
            ++n2;
        }
    }

    private void injectResponse(Field field, Response response) {
        field.setAccessible(true);
        try {
            field.set(this.target, response);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Could not inject response.", exception);
        }
    }
}

