/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.restfuse.internal;

import com.eclipsesource.restfuse.AuthenticationType;
import com.eclipsesource.restfuse.Response;
import com.eclipsesource.restfuse.internal.AuthenticationInfo;
import com.eclipsesource.restfuse.internal.ResponseImpl;
import com.github.kevinsawicki.http.HttpRequest;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InternalRequest {
    private final Map<String, List<String>> headers;
    private final List<AuthenticationInfo> authentications;
    private final String url;
    private InputStream content;
    private String mediaType;

    public InternalRequest(String url) {
        this.url = url;
        this.headers = new HashMap<String, List<String>>();
        this.authentications = new ArrayList<AuthenticationInfo>();
    }

    public void setContentType(String mediaType) {
        this.mediaType = mediaType;
    }

    public void setContent(InputStream content) {
        this.content = content;
    }

    public void addHeader(String name, String value) {
        List<String> param = this.headers.get(name);
        if (param == null) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(value);
            this.headers.put(name, params);
        } else {
            param.add(value);
        }
    }

    public void addAuthenticationInfo(AuthenticationInfo authentication) {
        this.authentications.add(authentication);
    }

    public Response get() {
        HttpRequest request = HttpRequest.get(this.url);
        this.addContentType(request);
        this.addHeaders(request);
        this.addAuthentication(request);
        this.sendRequest(request);
        return new ResponseImpl(request);
    }

    public Response post() {
        HttpRequest request = HttpRequest.post(this.url);
        this.addContentType(request);
        this.addHeaders(request);
        this.addAuthentication(request);
        request.send(this.content);
        this.sendRequest(request);
        return new ResponseImpl(request);
    }

    public Response delete() {
        HttpRequest request = HttpRequest.delete(this.url);
        this.addContentType(request);
        this.addHeaders(request);
        this.addAuthentication(request);
        this.sendRequest(request);
        return new ResponseImpl(request);
    }

    public Response put() {
        HttpRequest request = HttpRequest.put(this.url);
        this.addContentType(request);
        this.addHeaders(request);
        this.addAuthentication(request);
        request.send(this.content);
        this.sendRequest(request);
        return new ResponseImpl(request);
    }

    public Response head() {
        HttpRequest request = HttpRequest.head(this.url);
        this.addContentType(request);
        this.addHeaders(request);
        this.addAuthentication(request);
        this.sendRequest(request);
        return new ResponseImpl(request);
    }

    public Response options() {
        HttpRequest request = HttpRequest.options(this.url);
        this.addContentType(request);
        this.addHeaders(request);
        this.addAuthentication(request);
        this.sendRequest(request);
        return new ResponseImpl(request);
    }

    private void addContentType(HttpRequest request) {
        String type = this.mediaType != null ? this.mediaType : "*/*";
        request.contentType(type);
    }

    private void addHeaders(HttpRequest request) {
        Set<String> keySet = this.headers.keySet();
        for (String key : keySet) {
            List<String> values = this.headers.get(key);
            StringBuilder builder = new StringBuilder();
            for (String value : values) {
                builder.append(String.valueOf(value) + ",");
            }
            request.header(key, builder.substring(0, builder.length() - 1));
        }
        request.trustAllCerts();
        request.trustAllHosts();
    }

    private void addAuthentication(HttpRequest request) {
        for (AuthenticationInfo authentication : this.authentications) {
            if (authentication.getType().equals((Object)AuthenticationType.BASIC)) {
                request.basic(authentication.getUser(), authentication.getPassword());
                continue;
            }
            authentication.getType().equals((Object)AuthenticationType.DIGEST);
        }
    }

    private void sendRequest(HttpRequest request) {
        request.code();
    }

    String getUrl() {
        return this.url;
    }
}

