/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.restfuse.internal.callback;

import com.eclipsesource.restfuse.Response;
import com.eclipsesource.restfuse.annotation.Callback;
import com.eclipsesource.restfuse.internal.HttpTestStatement;
import com.eclipsesource.restfuse.internal.callback.CallbackServer;
import org.junit.Assert;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class CallbackStatement
extends Statement {
    private static final int WAIT_TIME = 100;
    private HttpTestStatement base;
    private Description description;
    private Object target;
    private CallbackServer callbackServer;
    private final Object lock = new Object();
    private volatile String errorMessage;
    private final Statement statement;

    public CallbackStatement(Statement statement, HttpTestStatement base, Description description, Object target) {
        this.statement = statement;
        this.base = base;
        this.description = description;
        this.target = target;
    }

    public void evaluate() throws Throwable {
        try {
            this.startCallbackServerWhenAvailable();
            Response response = this.base.sendRequest();
            this.base.tryInjectResponse(response);
            this.statement.evaluate();
        }
        finally {
            this.waitForCallbackWhenAvailable();
        }
    }

    private void startCallbackServerWhenAvailable() {
        Callback callbackAnnotation = (Callback)this.description.getAnnotation(Callback.class);
        if (callbackAnnotation != null) {
            this.callbackServer = new CallbackServer(callbackAnnotation, this.target, this);
            this.callbackServer.start();
        }
    }

    private void waitForCallbackWhenAvailable() {
        if (this.callbackServer != null) {
            try {
                int waitTime = 0;
                while (!this.callbackServer.wasCalled() && waitTime <= this.callbackServer.getTimeout()) {
                    this.sleep();
                    waitTime += 100;
                }
                this.checkForFailuresDuringCallback();
                this.checkCallbackWasCalled();
            }
            finally {
                this.callbackServer.stop();
            }
        }
    }

    private void sleep() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException shouldNotHappen) {
            throw new IllegalStateException("Could not wait until callback was called", shouldNotHappen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForFailuresDuringCallback() {
        Object object = this.lock;
        synchronized (object) {
            if (this.errorMessage != null) {
                Assert.fail((String)this.errorMessage);
            }
        }
    }

    private void checkCallbackWasCalled() {
        if (!this.callbackServer.wasCalled()) {
            Assert.fail((String)"Callback was not called");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failWithinCallback(Throwable cause) {
        Object object = this.lock;
        synchronized (object) {
            this.errorMessage = cause.getMessage();
        }
    }
}

