/*
 * Decompiled with CFR 0.152.
 */
package com.rmn.testrail.entity;

import com.rmn.testrail.entity.BaseEntity;
import com.rmn.testrail.entity.TestRun;
import com.rmn.testrail.entity.TestRunGroup;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TestPlan
extends BaseEntity {
    @JsonProperty(value="id")
    private Integer id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="milestone_id")
    private Integer milestoneId;
    @JsonProperty(value="is_completed")
    private Boolean isCompleted;
    @JsonProperty(value="created_by")
    private int createdBy;
    @JsonProperty(value="created_on")
    private String createdOn;
    @JsonProperty(value="completed_on")
    private String completedOn;
    @JsonProperty(value="passed_count")
    private Integer passedCount;
    @JsonProperty(value="blocked_count")
    private Integer blockedCount;
    @JsonProperty(value="untested_count")
    private Integer untestedCount;
    @JsonProperty(value="retest_count")
    private Integer retestCount;
    @JsonProperty(value="failed_count")
    private Integer failedCount;
    @JsonProperty(value="project_id")
    private Integer projectId;
    @JsonProperty(value="assignedto_id")
    private Integer assignedtoId;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="entries")
    private List<TestRunGroup> entries;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getMilestoneId() {
        return this.milestoneId;
    }

    public void setMilestoneId(Integer milestoneId) {
        this.milestoneId = milestoneId;
    }

    public Boolean isCompleted() {
        return this.isCompleted;
    }

    public void setIsCompleted(Boolean isCompleted) {
        this.isCompleted = isCompleted;
    }

    public int getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(int createdBy) {
        this.createdBy = createdBy;
    }

    public String getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(String createdOn) {
        this.createdOn = createdOn;
    }

    public String getCompletedOn() {
        return this.completedOn;
    }

    public void setCompletedOn(String completedOn) {
        this.completedOn = completedOn;
    }

    public Integer getPassedCount() {
        return this.passedCount;
    }

    public void setPassedCount(Integer passedCount) {
        this.passedCount = passedCount;
    }

    public Integer getBlockedCount() {
        return this.blockedCount;
    }

    public void setBlockedCount(Integer blockedCount) {
        this.blockedCount = blockedCount;
    }

    public Integer getUntestedCount() {
        return this.untestedCount;
    }

    public void setUntestedCount(Integer untestedCount) {
        this.untestedCount = untestedCount;
    }

    public Integer getRetestCount() {
        return this.retestCount;
    }

    public void setRetestCount(Integer retestCount) {
        this.retestCount = retestCount;
    }

    public Integer getFailedCount() {
        return this.failedCount;
    }

    public void setFailedCount(Integer failedCount) {
        this.failedCount = failedCount;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public Integer getAssignedtoId() {
        return this.assignedtoId;
    }

    public void setAssignedtoId(Integer assignedtoId) {
        this.assignedtoId = assignedtoId;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setEntries(List<TestRunGroup> entries) {
        this.entries = entries;
    }

    public List<TestRunGroup> getEntries() {
        this.refreshEntriesFromService();
        return this.entries;
    }

    private void refreshEntriesFromService() {
        TestPlan plan = this.getTestRailService().getTestPlan(this.getId());
        this.setEntries(plan.entries);
    }

    public List<TestRun> getTestRuns() {
        this.refreshEntriesFromService();
        ArrayList<TestRun> testRuns = new ArrayList<TestRun>(this.entries.size());
        for (TestRunGroup group : this.entries) {
            TestRun testRun = group.getRuns().get(0);
            if (null == testRun) continue;
            testRun.setTestRailService(this.getTestRailService());
            testRuns.add(testRun);
        }
        return testRuns;
    }
}

