/*
 * Decompiled with CFR 0.152.
 */
package com.rmn.testrail.service;

import com.rmn.testrail.entity.BaseEntity;
import com.rmn.testrail.entity.EmptyMilestone;
import com.rmn.testrail.entity.Error;
import com.rmn.testrail.entity.Milestone;
import com.rmn.testrail.entity.PlanEntry;
import com.rmn.testrail.entity.Priority;
import com.rmn.testrail.entity.Project;
import com.rmn.testrail.entity.ProjectCreator;
import com.rmn.testrail.entity.Section;
import com.rmn.testrail.entity.SectionCreator;
import com.rmn.testrail.entity.TestCase;
import com.rmn.testrail.entity.TestInstance;
import com.rmn.testrail.entity.TestPlan;
import com.rmn.testrail.entity.TestPlanCreator;
import com.rmn.testrail.entity.TestResult;
import com.rmn.testrail.entity.TestResults;
import com.rmn.testrail.entity.TestRun;
import com.rmn.testrail.entity.TestRunCreator;
import com.rmn.testrail.entity.TestRunUpdater;
import com.rmn.testrail.entity.TestSuite;
import com.rmn.testrail.entity.TestSuiteCreator;
import com.rmn.testrail.entity.UpdatePlanEntry;
import com.rmn.testrail.entity.User;
import com.rmn.testrail.parameters.ApiFilterValue;
import com.rmn.testrail.parameters.ApiParameter;
import com.rmn.testrail.parameters.ApiParameters;
import com.rmn.testrail.parameters.GetResultsFilter;
import com.rmn.testrail.service.TestRailCommand;
import com.rmn.testrail.util.HTTPUtils;
import com.rmn.testrail.util.JSONUtils;
import java.io.IOException;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRailService
implements Serializable {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String ENDPOINT_SUFFIX = "index.php?/api/v2/%s%s";
    private String apiEndpoint = "https://%s.testrail.com/";
    private String username;
    private String password;
    private HTTPUtils utils = new HTTPUtils();

    public TestRailService() {
    }

    public TestRailService(String clientId, String username, String password) {
        this.apiEndpoint = String.format(this.apiEndpoint, clientId) + ENDPOINT_SUFFIX;
        this.username = username;
        this.password = password;
    }

    public TestRailService(URL apiEndpoint, String username, String password) {
        this.apiEndpoint = apiEndpoint.toString() + ENDPOINT_SUFFIX;
        this.username = username;
        this.password = password;
    }

    public void setApiEndpoint(URL apiEndpoint) {
        this.apiEndpoint = apiEndpoint.toString() + ENDPOINT_SUFFIX;
    }

    public void setClientId(String clientId) {
        this.apiEndpoint = String.format(this.apiEndpoint, clientId) + ENDPOINT_SUFFIX;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setHttpUtils(HTTPUtils utils) {
        this.utils = utils;
    }

    protected <T extends BaseEntity> List<T> getEntityList(Class<T> clazz, String apiCall, String param) {
        HttpURLConnection connection = this.getRESTRequest(apiCall, param);
        this.log.debug("");
        String contents = this.utils.getContentsFromConnection(connection);
        List<BaseEntity> entities = JSONUtils.getMappedJsonObjectList(clazz, contents);
        for (BaseEntity suite : entities) {
            suite.setTestRailService(this);
        }
        return entities;
    }

    protected <T extends BaseEntity> T getEntitySingle(Class<T> clazz, String apiCall, String param) {
        HttpURLConnection connection = this.getRESTRequest(apiCall, param);
        String contents = this.utils.getContentsFromConnection(connection);
        BaseEntity entity = (BaseEntity)JSONUtils.getMappedJsonObject(clazz, contents);
        entity.setTestRailService(this);
        return (T)entity;
    }

    public boolean verifyCredentials() throws IOException {
        HttpURLConnection connection = this.getRESTRequest(TestRailCommand.GET_PROJECTS.getCommand(), "");
        return connection.getResponseCode() == 200;
    }

    public TestCase getTestCase(int testCaseId) {
        return this.getEntitySingle(TestCase.class, TestRailCommand.GET_CASE.getCommand(), Integer.toString(testCaseId));
    }

    public List<TestCase> getTestCasesSingleSuiteMode(int projectId, ApiFilterValue ... apiFilters) {
        return this.getTestCases(projectId, -1, -1, apiFilters);
    }

    public List<TestCase> getTestCasesSingleSuiteMode(int projectId, int sectionId, ApiFilterValue ... apiFilters) {
        return this.getTestCases(projectId, -1, sectionId, apiFilters);
    }

    public List<TestCase> getTestCases(int projectId, int suiteId, ApiFilterValue ... apiFilters) {
        return this.getTestCases(projectId, suiteId, -1, apiFilters);
    }

    public List<TestCase> getTestCases(int projectId, int suiteId, int sectionId, ApiFilterValue ... apiFilters) {
        String params = Integer.toString(projectId);
        if (suiteId > 0) {
            params = params + ApiParameters.append(ApiParameter.SUITE_ID, suiteId);
        }
        if (sectionId > 0) {
            params = params + ApiParameters.append(ApiParameter.SECTION_ID, sectionId);
        }
        for (ApiFilterValue apiFilter : apiFilters) {
            params = params + apiFilter.append();
        }
        return this.getEntityList(TestCase.class, TestRailCommand.GET_CASES.getCommand(), params);
    }

    public TestCase addTestCase(TestCase testCase, int sectionId) {
        return this.postRESTBodyReturn(TestRailCommand.ADD_CASE.getCommand(), Integer.toString(sectionId), testCase, TestCase.class);
    }

    public TestCase updateTestCase(TestCase testCase, int caseId) {
        return this.postRESTBodyReturn(TestRailCommand.UPDATE_CASE.getCommand(), Integer.toString(caseId), testCase, TestCase.class);
    }

    public void deleteTestCase(int caseId) {
        this.postRESTBody(TestRailCommand.DELETE_CASE.getCommand(), Integer.toString(caseId), null);
    }

    public String getCaseFields() {
        HttpURLConnection connection = this.getRESTRequest(TestRailCommand.GET_CASE_FIELDS.getCommand(), null);
        return this.utils.getContentsFromConnection(connection);
    }

    public String getCaseTypes() {
        HttpURLConnection connection = this.getRESTRequest(TestRailCommand.GET_CASE_TYPES.getCommand(), null);
        return this.utils.getContentsFromConnection(connection);
    }

    public String getConfigurations(int projectId) {
        HttpURLConnection connection = this.getRESTRequest(TestRailCommand.GET_CONFIGS.getCommand(), Integer.toString(projectId));
        return this.utils.getContentsFromConnection(connection);
    }

    public void addConfigGroup(final String name, int projectId) {
        this.postRESTBody(TestRailCommand.ADD_CONFIG_GROUP.getCommand(), null, new BaseEntity(){
            @JsonProperty(value="name")
            private String nameString;
            {
                this.nameString = name;
            }
        });
    }

    public void addConfig(final String name, int configGroupId) {
        this.postRESTBody(TestRailCommand.ADD_CONFIG.getCommand(), Integer.toString(configGroupId), new BaseEntity(){
            @JsonProperty(value="name")
            private String nameString;
            {
                this.nameString = name;
            }
        });
    }

    public void updateConfigGroup(final String name, int configGroupId) {
        this.postRESTBody(TestRailCommand.UPDATE_CONFIG_GROUP.getCommand(), Integer.toString(configGroupId), new BaseEntity(){
            @JsonProperty(value="name")
            private String nameString;
            {
                this.nameString = name;
            }
        });
    }

    public void updateConfig(final String name, int configId) {
        this.postRESTBody(TestRailCommand.UPDATE_CONFIG.getCommand(), Integer.toString(configId), new BaseEntity(){
            @JsonProperty(value="name")
            private String nameString;
            {
                this.nameString = name;
            }
        });
    }

    public void deleteConfigGroup(int configGroupId) {
        this.postRESTBody(TestRailCommand.DELETE_CONFIG_GROUP.getCommand(), Integer.toString(configGroupId), null);
    }

    public void deleteConfig(int configId) {
        this.postRESTBody(TestRailCommand.DELETE_CONFIG.getCommand(), Integer.toString(configId), null);
    }

    public Milestone getMilestone(int milestoneId) {
        return this.getEntitySingle(Milestone.class, TestRailCommand.GET_MILESTONE.getCommand(), Integer.toString(milestoneId));
    }

    public List<Milestone> getMilestones(int projectId, ApiFilterValue ... isCompleted) {
        return this.getEntityList(Milestone.class, TestRailCommand.GET_MILESTONES.getCommand(), Integer.toString(projectId) + (isCompleted.length > 0 ? isCompleted[0].append() : ""));
    }

    public Milestone addMilestone(EmptyMilestone milestone, int projectId) {
        return this.postRESTBodyReturn(TestRailCommand.ADD_MILESTONE.getCommand(), Integer.toString(projectId), milestone, Milestone.class);
    }

    public Milestone updateMilestone(int milestoneId, final boolean isCompleted) {
        return this.postRESTBodyReturn(TestRailCommand.UPDATE_MILESTONE.getCommand(), Integer.toString(milestoneId), new BaseEntity(){
            @JsonProperty(value="is_completed")
            private String isCompletedBoolean;
            {
                this.isCompletedBoolean = isCompleted ? "1" : "0";
            }
        }, Milestone.class);
    }

    public TestPlan getTestPlan(int planId) {
        return this.getEntitySingle(TestPlan.class, TestRailCommand.GET_PLAN.getCommand(), Integer.toString(planId));
    }

    public List<TestPlan> getTestPlans(int projectId, ApiFilterValue ... apiFilters) {
        String params = Integer.toString(projectId);
        for (ApiFilterValue apiFilter : apiFilters) {
            params = params + apiFilter.append();
        }
        return this.getEntityList(TestPlan.class, TestRailCommand.GET_PLANS.getCommand(), params);
    }

    public TestPlan addTestPlan(int projectId, TestPlanCreator testPlan) {
        return this.postRESTBodyReturn(TestRailCommand.ADD_PLAN.getCommand(), Integer.toString(projectId), testPlan, TestPlan.class);
    }

    public PlanEntry addTestPlanEntry(int planId, PlanEntry planEntry) {
        return this.postRESTBodyReturn(TestRailCommand.ADD_PLAN_ENTRY.getCommand(), Integer.toString(planId), planEntry, PlanEntry.class);
    }

    public TestPlan updateTestPlan(int planId, TestPlanCreator testPlan) {
        return this.postRESTBodyReturn(TestRailCommand.UPDATE_PLAN.getCommand(), Integer.toString(planId), testPlan, TestPlan.class);
    }

    public PlanEntry updateTestPlanEntry(int planId, String entryId, UpdatePlanEntry updatePlanEntry) {
        return this.postRESTBodyReturn(TestRailCommand.UPDATE_PLAN_ENTRY.getCommand(), Integer.toString(planId) + "/" + entryId, updatePlanEntry, PlanEntry.class);
    }

    public TestPlan closeTestPlan(int planId) {
        return this.postRESTBodyReturn(TestRailCommand.CLOSE_PLAN.getCommand(), Integer.toString(planId), null, TestPlan.class);
    }

    public void deleteTestPlan(int planId) {
        this.postRESTBody(TestRailCommand.DELETE_PLAN.getCommand(), Integer.toString(planId), null);
    }

    public void deleteTestPlanEntry(int planId, int entryId) {
        this.postRESTBody(TestRailCommand.DELETE_PLAN_ENTRY.getCommand(), Integer.toString(planId) + "/" + Integer.toString(entryId), null);
    }

    public List<Priority> getPriorities() {
        return this.getEntityList(Priority.class, TestRailCommand.GET_PRIORITIES.getCommand(), null);
    }

    public Project getProject(int projectId) {
        return this.getEntitySingle(Project.class, TestRailCommand.GET_PROJECT.getCommand(), Integer.toString(projectId));
    }

    public Project getProjectByName(String projectName) {
        for (Project project : this.getProjects(new ApiFilterValue[0])) {
            if (!project.getName().equals(projectName)) continue;
            return project;
        }
        return null;
    }

    public List<Project> getProjects(ApiFilterValue ... isCompleted) {
        return this.getEntityList(Project.class, TestRailCommand.GET_PROJECTS.getCommand(), isCompleted.length > 0 ? isCompleted[0].append() : "");
    }

    public Project addProject(ProjectCreator newProject) {
        return this.postRESTBodyReturn(TestRailCommand.ADD_PROJECT.getCommand(), null, newProject, Project.class);
    }

    public Project updateProject(int projectId, final boolean isCompleted) {
        return this.postRESTBodyReturn(TestRailCommand.ADD_PROJECT.getCommand(), Integer.toString(projectId), new BaseEntity(){
            @JsonProperty(value="is_completed")
            private String isCompletedBoolean;
            {
                this.isCompletedBoolean = isCompleted ? "1" : "0";
            }
        }, Project.class);
    }

    public void deleteProject(int projectId) {
        this.postRESTBody(TestRailCommand.DELETE_PROJECT.getCommand(), Integer.toString(projectId), null);
    }

    public TestResult getTestResult(int testInstanceId) {
        List<TestResult> results = this.getTestResults(testInstanceId, new ApiFilterValue(GetResultsFilter.LIMIT, "1"));
        if (null == results || results.size() == 0) {
            return null;
        }
        return results.get(0);
    }

    public List<TestResult> getTestResults(int testInstanceId, ApiFilterValue ... apiFilters) {
        List<TestResult> results = this.getEntityList(TestResult.class, TestRailCommand.GET_RESULTS.getCommand(), Integer.toString(testInstanceId) + new ApiFilterValue(GetResultsFilter.LIMIT, "1").append());
        if (null == results) {
            return null;
        }
        String params = Integer.toString(testInstanceId);
        for (ApiFilterValue apiFilter : apiFilters) {
            params = params + apiFilter.append();
        }
        return this.getEntityList(TestResult.class, TestRailCommand.GET_RESULTS.getCommand(), params);
    }

    public List<TestResult> getTestResultsForCase(int runId, int caseId, ApiFilterValue ... apiFilters) {
        String params = Integer.toString(runId) + "/" + Integer.toString(caseId);
        for (ApiFilterValue apiFilter : apiFilters) {
            params = params + apiFilter.append();
        }
        return this.getEntityList(TestResult.class, TestRailCommand.GET_RESULTS_FOR_CASE.getCommand(), params);
    }

    public List<TestResult> getTestResultsForRun(int runId, ApiFilterValue ... apiFilters) {
        String params = Integer.toString(runId);
        for (ApiFilterValue apiFilter : apiFilters) {
            params = params + apiFilter.append();
        }
        return this.getEntityList(TestResult.class, TestRailCommand.GET_RESULTS_FOR_RUN.getCommand(), params);
    }

    public TestResult addTestResult(int testId, TestResult result) {
        HttpResponse response = this.postRESTBody(TestRailCommand.ADD_RESULT.getCommand(), Integer.toString(testId), result);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new RuntimeException(String.format("TestResult was not properly added to TestInstance [%d]: %s", testId, response.getStatusLine().getReasonPhrase()));
        }
        try {
            return JSONUtils.getMappedJsonObject(TestResult.class, this.utils.getContentsFromHttpResponse(response));
        }
        catch (IOException e) {
            System.out.println("IOException occurred: " + e);
            return null;
        }
    }

    public TestResult addTestResultForCase(int runId, int caseId, TestResult result) {
        HttpResponse response = this.postRESTBody(TestRailCommand.ADD_RESULT_FOR_CASE.getCommand(), Integer.toString(runId) + "/" + Integer.toString(caseId), result);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new RuntimeException(String.format("TestResult was not properly added to Run ID: %d | Case ID: %d: %s", runId, caseId, response.getStatusLine().getReasonPhrase()));
        }
        try {
            return JSONUtils.getMappedJsonObject(TestResult.class, this.utils.getContentsFromHttpResponse(response));
        }
        catch (IOException e) {
            System.out.println("IOException occurred: " + e);
            return null;
        }
    }

    public TestResults addTestResults(int runId, TestResults results) {
        HttpResponse response = this.postRESTBody(TestRailCommand.ADD_RESULTS.getCommand(), Integer.toString(runId), results);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new RuntimeException(String.format("TestResults was not properly added to TestRun [%d]: %s", runId, response.getStatusLine().getReasonPhrase()));
        }
        TestResults returnedResults = new TestResults();
        try {
            returnedResults.setResults(JSONUtils.getMappedJsonObjectList(TestResult.class, this.utils.getContentsFromHttpResponse(response)));
            return returnedResults;
        }
        catch (IOException e) {
            System.out.println("IOException occurred: " + e);
            return null;
        }
    }

    public TestResults addTestResultsForCases(int runId, TestResults results) {
        HttpResponse response = this.postRESTBody(TestRailCommand.ADD_RESULTS_FOR_CASES.getCommand(), Integer.toString(runId), results);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new RuntimeException(String.format("TestResults was not properly added to TestRun [%d]: %s", runId, response.getStatusLine().getReasonPhrase()));
        }
        TestResults returnedResults = new TestResults();
        try {
            returnedResults.setResults(JSONUtils.getMappedJsonObjectList(TestResult.class, this.utils.getContentsFromHttpResponse(response)));
            return returnedResults;
        }
        catch (IOException e) {
            System.out.println("IOException occurred: " + e);
            return null;
        }
    }

    public String getResultFields() {
        HttpURLConnection connection = this.getRESTRequest(TestRailCommand.GET_RESULT_FIELDS.getCommand(), null);
        return this.utils.getContentsFromConnection(connection);
    }

    public TestRun getTestRun(int testRunId) {
        return this.getEntitySingle(TestRun.class, TestRailCommand.GET_RUN.getCommand(), Integer.toString(testRunId));
    }

    public List<TestRun> getTestRuns(int projectId, ApiFilterValue ... apiFilters) {
        String params = Integer.toString(projectId);
        for (ApiFilterValue apiFilter : apiFilters) {
            params = params + apiFilter.append();
        }
        return this.getEntityList(TestRun.class, TestRailCommand.GET_RUNS.getCommand(), params);
    }

    public TestRun addTestRun(int projectId, TestRunCreator run) {
        TestRun newSkeletonTestRun = this.postRESTBodyReturn(TestRailCommand.ADD_RUN.getCommand(), Integer.toString(projectId), run, TestRun.class);
        return this.getTestRun(newSkeletonTestRun.getId());
    }

    public TestRun updateTestRun(int runId, TestRunUpdater testRunUpdater) {
        return this.postRESTBodyReturn(TestRailCommand.UPDATE_RUN.getCommand(), Integer.toString(runId), testRunUpdater, TestRun.class);
    }

    public TestRun closeTestRun(TestRun run) {
        HttpResponse response = this.postRESTBody(TestRailCommand.CLOSE_RUN.getCommand(), Integer.toString(run.getId()), run);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new RuntimeException(String.format("TestRun was not properly closed, TestRunID [%d]: %s", run.getId(), response.getStatusLine().getReasonPhrase()));
        }
        try {
            return JSONUtils.getMappedJsonObject(TestRun.class, this.utils.getContentsFromHttpResponse(response));
        }
        catch (IOException e) {
            return null;
        }
    }

    public TestRun closeTestRun(int runId) {
        HttpResponse response = this.postRESTBody(TestRailCommand.CLOSE_RUN.getCommand(), Integer.toString(runId), null);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new RuntimeException(String.format("TestRun was not properly closed, TestRunID [%d]: %s", runId, response.getStatusLine().getReasonPhrase()));
        }
        try {
            return JSONUtils.getMappedJsonObject(TestRun.class, this.utils.getContentsFromHttpResponse(response));
        }
        catch (IOException e) {
            System.out.println("IOException occurred: " + e);
            return null;
        }
    }

    public void deleteTestRun(int runId) {
        this.postRESTBody(TestRailCommand.DELETE_RUN.getCommand(), Integer.toString(runId), null);
    }

    public Section addSection(int projectId, SectionCreator sectionCreator) {
        return this.postRESTBodyReturn(TestRailCommand.ADD_SECTION.getCommand(), Integer.toString(projectId), sectionCreator, Section.class);
    }

    public Section getSection(int sectionId) {
        return this.getEntitySingle(Section.class, TestRailCommand.GET_SECTION.getCommand(), Integer.toString(sectionId));
    }

    public List<Section> getSections(int projectId, int suiteId) {
        return this.getEntityList(Section.class, TestRailCommand.GET_SECTIONS.getCommand(), Integer.toString(projectId) + ApiParameters.append(ApiParameter.SUITE_ID, suiteId));
    }

    public String getStatuses() {
        HttpURLConnection connection = this.getRESTRequest(TestRailCommand.GET_STATUSES.getCommand(), null);
        return this.utils.getContentsFromConnection(connection);
    }

    public TestSuite getTestSuite(int suiteId) {
        return this.getEntitySingle(TestSuite.class, TestRailCommand.GET_SUITE.getCommand(), Integer.toString(suiteId));
    }

    public List<TestSuite> getTestSuites(int projectId) {
        return this.getEntityList(TestSuite.class, TestRailCommand.GET_SUITES.getCommand(), Integer.toString(projectId));
    }

    public TestSuite addTestSuite(int projectId, TestSuiteCreator testSuite) {
        return this.postRESTBodyReturn(TestRailCommand.ADD_SUITE.getCommand(), Integer.toString(projectId), testSuite, TestSuite.class);
    }

    public TestSuite updateTestSuite(int suiteId, TestSuite testSuite) {
        return this.postRESTBodyReturn(TestRailCommand.UPDATE_SUITE.getCommand(), Integer.toString(suiteId), testSuite, TestSuite.class);
    }

    public void deleteTestSuite(int suiteId) {
        this.postRESTBody(TestRailCommand.DELETE_SUITE.getCommand(), Integer.toString(suiteId), null);
    }

    public String getTemplates() {
        HttpURLConnection connection = this.getRESTRequest(TestRailCommand.GET_TEMPLATES.getCommand(), null);
        return this.utils.getContentsFromConnection(connection);
    }

    public TestInstance getTest(int testId) {
        return this.getEntitySingle(TestInstance.class, TestRailCommand.GET_TEST.getCommand(), Integer.toString(testId));
    }

    public List<TestInstance> getTests(int testRunId, ApiFilterValue ... statusId) {
        return this.getEntityList(TestInstance.class, TestRailCommand.GET_TESTS.getCommand(), Integer.toString(testRunId) + (statusId.length > 0 ? statusId[0].append() : ""));
    }

    public User getUserById(int id) {
        return this.getEntitySingle(User.class, TestRailCommand.GET_USER_BY_ID.getCommand(), "" + id);
    }

    public User getUserByEmail(String email) {
        return this.getEntitySingle(User.class, TestRailCommand.GET_USER_BY_EMAIL.getCommand(), "&email=" + email);
    }

    public List<User> getUsers() {
        return this.getEntityList(User.class, TestRailCommand.GET_USERS.getCommand(), "");
    }

    private String buildRequestURL(String apiCall, String urlParams) {
        String argString = "";
        if (!StringUtils.isEmpty((CharSequence)urlParams)) {
            argString = String.format("/%s", urlParams);
        }
        return String.format(this.apiEndpoint, apiCall, argString);
    }

    private HttpURLConnection getRESTRequest(String apiCall, String urlParams) {
        String completeUrl = this.buildRequestURL(apiCall, urlParams);
        try {
            this.log.debug("url: {}", (Object)completeUrl);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            String authentication = this.utils.encodeAuthenticationBase64(this.username, this.password);
            return this.utils.getHTTPRequest(completeUrl, authentication, headers);
        }
        catch (IOException e) {
            this.log.error("An IOException was thrown while trying to process a REST Request against URL: {}", (Object)completeUrl);
            throw new RuntimeException(String.format("Connection is null (probably hit timeout), check parameters for [%s]", completeUrl));
        }
    }

    private HttpResponse postRESTBody(String apiCall, String urlParams, BaseEntity entity) {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        String completeUrl = this.buildRequestURL(apiCall, urlParams);
        try {
            HttpPost request = new HttpPost(completeUrl);
            String authentication = this.utils.encodeAuthenticationBase64(this.username, this.password);
            request.addHeader("Authorization", "Basic " + authentication);
            request.addHeader("Content-Type", "application/json");
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
            byte[] body = mapper.writeValueAsBytes((Object)entity);
            request.setEntity((HttpEntity)new ByteArrayEntity(body));
            HttpResponse response = this.executeRequestWithRetry(request, 2);
            if (response.getStatusLine().getStatusCode() != 200) {
                Error error = JSONUtils.getMappedJsonObject(Error.class, this.utils.getContentsFromHttpResponse(response));
                this.log.error("Response code: {}", (Object)response.getStatusLine().getStatusCode());
                this.log.error("TestRails reported an error message: {}", (Object)error.getError());
                request.addHeader("Encoding", "UTF-8");
            }
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        catch (IOException e) {
            this.log.error(String.format("An IOException was thrown while trying to process a REST Request against URL: [%s]", completeUrl), (Object)e.toString());
            throw new RuntimeException(String.format("Connection is null, check URL: %s", completeUrl));
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    private <T extends BaseEntity> T postRESTBodyReturn(String apiCall, String urlParams, BaseEntity entity, Class<T> returnEntityType) {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        String completeUrl = this.buildRequestURL(apiCall, urlParams);
        try {
            HttpPost request = new HttpPost(completeUrl);
            String authentication = this.utils.encodeAuthenticationBase64(this.username, this.password);
            request.addHeader("Authorization", "Basic " + authentication);
            request.addHeader("Content-Type", "application/json");
            request.addHeader("Encoding", "UTF-8");
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
            byte[] body = mapper.writeValueAsBytes((Object)entity);
            request.setEntity((HttpEntity)new ByteArrayEntity(body));
            HttpResponse response = this.executeRequestWithRetry(request, 2);
            int responseStatusCode = response.getStatusLine().getStatusCode();
            if (responseStatusCode == 200) {
                this.log.info("Returning a JSON mapped object from calling api integration point");
                BaseEntity mappedJsonObject = (BaseEntity)JSONUtils.getMappedJsonObject(returnEntityType, this.utils.getContentsFromHttpResponse(response));
                mappedJsonObject.setTestRailService(this);
                BaseEntity baseEntity = mappedJsonObject;
                return (T)baseEntity;
            }
            Error error = JSONUtils.getMappedJsonObject(Error.class, this.utils.getContentsFromHttpResponse(response));
            this.log.error("Response code: {}", (Object)responseStatusCode);
            this.log.error("TestRails reported an error message: {}", (Object)error.getError());
        }
        catch (IOException e) {
            this.log.error(String.format("An IOException was thrown while trying to process a REST Request against URL: [%s]", completeUrl), (Throwable)e);
            throw new RuntimeException(String.format("Connection is null, check URL: %s", completeUrl), e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
        return null;
    }

    private HttpResponse executeRequestWithRetry(HttpPost request, int retries) throws IOException {
        boolean connected = false;
        int RETRY_DELAY_MS = 0;
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpResponse response = null;
        for (int retry = 0; retry < retries && !connected; ++retry) {
            int retryDelayInMS;
            if (retry > 0) {
                this.log.warn("retry " + retry + "/" + retries);
                try {
                    this.log.debug("Sleeping for retry: " + RETRY_DELAY_MS);
                    Thread.sleep(RETRY_DELAY_MS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if ((response = httpClient.execute((HttpUriRequest)request)).getStatusLine().getStatusCode() != 429) break;
            this.log.warn(" **429 for POST**");
            RETRY_DELAY_MS = retryDelayInMS = Integer.parseInt(response.getFirstHeader("Retry-After").getValue()) * 1000;
        }
        return response;
    }
}

