/*
 * Decompiled with CFR 0.152.
 */
package com.rmn.testrail.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPUtils
implements Serializable {
    private static final int REQUEST_TIMEOUT = 60000;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public HttpURLConnection getHTTPRequest(String completeUrl, String authentication, Map<String, String> headers) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(completeUrl).openConnection();
        connection.setRequestProperty("Authorization", "Basic " + authentication);
        this.log.debug("Attempting to get {}", (Object)completeUrl);
        if (headers != null) {
            for (String key : headers.keySet()) {
                String value = headers.get(key);
                this.log.debug("Adding header [{}: {}]", (Object)key, (Object)value);
                connection.setRequestProperty(key, value);
            }
        }
        return this.submitRequestFromConnectionWithRetry(connection, 2);
    }

    private HttpURLConnection submitRequestFromConnectionWithRetry(HttpURLConnection connection, int retries) throws IOException {
        boolean connected = false;
        int RETRY_DELAY_MS = 500;
        connection.setReadTimeout(60000);
        connection.setConnectTimeout(60000);
        block8: for (int retry = 0; retry < retries && !connected; ++retry) {
            if (retry > 0) {
                this.log.warn("retry " + retry + "/" + retries);
                try {
                    this.log.debug("Sleeping for retry: " + RETRY_DELAY_MS);
                    Thread.sleep(RETRY_DELAY_MS);
                    RETRY_DELAY_MS = 500;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            connection.connect();
            switch (connection.getResponseCode()) {
                case 200: {
                    this.log.debug(" **OK**");
                    return connection;
                }
                case 504: {
                    this.log.warn(" **gateway timeout**");
                    continue block8;
                }
                case 429: {
                    int retryDelayInMS;
                    this.log.warn(" **429**");
                    RETRY_DELAY_MS = retryDelayInMS = Integer.parseInt(connection.getHeaderField("Retry-After")) * 1000;
                    continue block8;
                }
                case 503: {
                    this.log.warn("**unavailable**");
                    continue block8;
                }
                default: {
                    this.log.error(" **unknown response code**.");
                    break block8;
                }
            }
        }
        return connection;
    }

    private HttpURLConnection submitRequestFromConnection(HttpURLConnection connection) throws IOException {
        connection.setDoOutput(true);
        connection.setReadTimeout(60000);
        connection.setConnectTimeout(60000);
        this.log.debug("Sending request...");
        connection.connect();
        this.log.debug("Response: {}, {}", (Object)connection.getResponseCode(), (Object)connection.getResponseMessage());
        return connection;
    }

    public String getCurlCommandStringGet(String completeUrl, Map<String, String> headers) {
        String curlStr = "curl -v ";
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                curlStr = curlStr + String.format("-H \"%s: %s\"", entry.getKey(), entry.getValue());
            }
        }
        curlStr = curlStr + " " + completeUrl;
        return curlStr;
    }

    public String getCurlCommandStringPost(String completeUrl, Map<String, String> headers, List<NameValuePair> values) {
        String curlStr = "curl -v";
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                curlStr = curlStr + String.format(" -H \"%s: %s\"", entry.getKey(), entry.getValue());
            }
        }
        curlStr = curlStr + String.format(" -vi -X POST -d \"%s\" \"%s\"", values.toString(), completeUrl);
        return curlStr;
    }

    public String getContentsFromConnection(URLConnection connection) {
        InputStreamReader in;
        try {
            in = new InputStreamReader((InputStream)connection.getContent());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read contents from connection: " + e.getMessage());
        }
        return this.getContentsFromInputStream(in);
    }

    public String getContentsFromHttpResponse(HttpResponse response) throws IOException {
        InputStreamReader in = new InputStreamReader(response.getEntity().getContent());
        return this.getContentsFromInputStream(in);
    }

    private String getContentsFromInputStream(InputStreamReader in) {
        String line;
        BufferedReader buff = new BufferedReader(in);
        String text = "";
        do {
            try {
                line = buff.readLine();
                text = text + line + "\n";
            }
            catch (Exception ex) {
                return text;
            }
        } while (line != null);
        return text;
    }

    public String encodeAuthenticationBase64(String username, String password) {
        return Base64.encodeBase64String((byte[])String.format("%s:%s", username, password).getBytes());
    }
}

