/*
 * Decompiled with CFR 0.152.
 */
package com.rmn.testrail.util;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.type.JavaType;

public class JSONUtils {
    public static <T> T getMappedJsonObject(Class<T> jsonObjectClass, String json) {
        return JSONUtils.getMappedJsonObject(jsonObjectClass, json, false);
    }

    public static <T> T getMappedJsonObject(Class<T> jsonObjectClass, String json, boolean failOnUnknownProperties) {
        Object mappedObject;
        TypeFactory t = TypeFactory.defaultInstance();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, failOnUnknownProperties);
        try {
            mappedObject = mapper.readValue(json, t.constructType(jsonObjectClass));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instantiate object of class [" + jsonObjectClass.getName() + "]: " + e);
        }
        return (T)mappedObject;
    }

    public static <T> List<T> getMappedJsonObjectList(Class<T> jsonObjectClass, String json) {
        return JSONUtils.getMappedJsonObjectList(jsonObjectClass, json, true);
    }

    public static <T> List<T> getMappedJsonObjectList(Class<T> jsonObjectClass, String json, boolean failOnUnknownProperties) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, failOnUnknownProperties);
        TypeFactory t = TypeFactory.defaultInstance();
        try {
            List list = (List)mapper.readValue(json, (JavaType)t.constructCollectionType(ArrayList.class, jsonObjectClass));
            return list;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException("Could not process JSON");
        }
    }
}

