/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.gen.proto;

import java.util.Optional;

public enum ResponseNote {
    SEQUENCE_FEED(1),
    ATOM_FEED(2),
    ORDER_BY_LIMIT_FEED(3),
    UNIONED_FEED(4),
    INCLUDES_STATES(5);

    public final int value;

    private ResponseNote(int value) {
        this.value = value;
    }

    public static ResponseNote fromValue(int value) {
        switch (value) {
            case 1: {
                return SEQUENCE_FEED;
            }
            case 2: {
                return ATOM_FEED;
            }
            case 3: {
                return ORDER_BY_LIMIT_FEED;
            }
            case 4: {
                return UNIONED_FEED;
            }
            case 5: {
                return INCLUDES_STATES;
            }
        }
        throw new IllegalArgumentException(String.format("%s is not a legal value for ResponseNote", value));
    }

    public static Optional<ResponseNote> maybeFromValue(int value) {
        try {
            return Optional.of(ResponseNote.fromValue(value));
        }
        catch (IllegalArgumentException iae) {
            return Optional.empty();
        }
    }

    public boolean isFeed() {
        switch (this) {
            case SEQUENCE_FEED: {
                return true;
            }
            case ATOM_FEED: {
                return true;
            }
            case ORDER_BY_LIMIT_FEED: {
                return true;
            }
            case UNIONED_FEED: {
                return true;
            }
        }
        return false;
    }
}

