/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb;

import com.rethinkdb.ast.Query;
import com.rethinkdb.ast.ReqlAst;
import com.rethinkdb.gen.exc.ReqlClientError;
import com.rethinkdb.gen.exc.ReqlError;
import com.rethinkdb.gen.exc.ReqlInternalError;
import com.rethinkdb.gen.exc.ReqlNonExistenceError;
import com.rethinkdb.gen.exc.ReqlOpFailedError;
import com.rethinkdb.gen.exc.ReqlOpIndeterminateError;
import com.rethinkdb.gen.exc.ReqlPermissionError;
import com.rethinkdb.gen.exc.ReqlQueryLogicError;
import com.rethinkdb.gen.exc.ReqlResourceLimitError;
import com.rethinkdb.gen.exc.ReqlRuntimeError;
import com.rethinkdb.gen.exc.ReqlServerCompileError;
import com.rethinkdb.gen.exc.ReqlUserError;
import com.rethinkdb.gen.proto.ErrorType;
import com.rethinkdb.gen.proto.ResponseType;
import com.rethinkdb.model.Backtrace;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class ErrorBuilder {
    private final String msg;
    private final ResponseType responseType;
    @Nullable
    private Backtrace backtrace;
    @Nullable
    private ErrorType errorType;
    @Nullable
    private ReqlAst term;

    public ErrorBuilder(String msg, ResponseType responseType) {
        this.msg = msg;
        this.responseType = responseType;
    }

    public ErrorBuilder setBacktrace(@Nullable Backtrace backtrace) {
        this.backtrace = backtrace;
        return this;
    }

    public ErrorBuilder setErrorType(@Nullable ErrorType errorType) {
        this.errorType = errorType;
        return this;
    }

    public ErrorBuilder setTerm(Query query) {
        this.term = query.term;
        return this;
    }

    public ReqlError build() {
        Function<String, ReqlError> con;
        assert (this.msg != null);
        assert (this.responseType != null);
        block0 : switch (this.responseType) {
            case CLIENT_ERROR: {
                con = ReqlClientError::new;
                break;
            }
            case COMPILE_ERROR: {
                con = ReqlServerCompileError::new;
                break;
            }
            case RUNTIME_ERROR: {
                if (this.errorType == null) {
                    con = ReqlRuntimeError::new;
                    break;
                }
                switch (this.errorType) {
                    case INTERNAL: {
                        con = ReqlInternalError::new;
                        break block0;
                    }
                    case RESOURCE_LIMIT: {
                        con = ReqlResourceLimitError::new;
                        break block0;
                    }
                    case QUERY_LOGIC: {
                        con = ReqlQueryLogicError::new;
                        break block0;
                    }
                    case NON_EXISTENCE: {
                        con = ReqlNonExistenceError::new;
                        break block0;
                    }
                    case OP_FAILED: {
                        con = ReqlOpFailedError::new;
                        break block0;
                    }
                    case OP_INDETERMINATE: {
                        con = ReqlOpIndeterminateError::new;
                        break block0;
                    }
                    case USER: {
                        con = ReqlUserError::new;
                        break block0;
                    }
                    case PERMISSION_ERROR: {
                        con = ReqlPermissionError::new;
                        break block0;
                    }
                }
                con = ReqlRuntimeError::new;
                break;
            }
            default: {
                con = ReqlError::new;
            }
        }
        return con.apply(this.msg).setBacktrace(this.backtrace).setTerm(this.term);
    }
}

