/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.rethinkdb.gen.model.TopLevel;
import com.rethinkdb.net.Connection;
import java.net.URI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RethinkDB
extends TopLevel {
    public static final RethinkDB r = new RethinkDB();
    private static ObjectMapper resultMapper;

    @NotNull
    public static synchronized ObjectMapper getResultMapper() {
        ObjectMapper mapper = resultMapper;
        if (mapper == null) {
            resultMapper = mapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        }
        return mapper;
    }

    public static synchronized void setResultMapper(@Nullable ObjectMapper mapper) {
        resultMapper = mapper;
    }

    @NotNull
    public Connection.Builder connection() {
        return new Connection.Builder();
    }

    @NotNull
    public Connection.Builder connection(@NotNull String dburl) {
        return this.connection(URI.create(dburl));
    }

    @NotNull
    public Connection.Builder connection(@NotNull URI uri) {
        return new Connection.Builder(uri);
    }

    @NotNull
    public Connection.Builder connection(Connection.Builder b) {
        return new Connection.Builder(b);
    }
}

