/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class GroupedResult<G, V> {
    private final G group;
    private final List<V> values;

    @JsonCreator
    public GroupedResult(@JsonProperty(value="group") G group, @JsonProperty(value="values") List<V> values) {
        this.group = group;
        this.values = values;
    }

    public G getGroup() {
        return this.group;
    }

    public List<V> getValues() {
        return this.values;
    }

    public static <G, V> Map<G, Set<V>> toMap(List<GroupedResult<G, V>> list) {
        return list.stream().collect(Collectors.toMap(GroupedResult::getGroup, it -> new LinkedHashSet(it.getValues())));
    }

    public String toString() {
        return "GroupedResult{group=" + this.group + ", values=" + this.values + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupedResult that = (GroupedResult)o;
        return Objects.equals(this.group, that.group) && Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.values);
    }
}

