/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.net;

import com.rethinkdb.gen.exc.ReqlDriverError;
import com.rethinkdb.net.ConnectionSocket;
import com.rethinkdb.net.Response;
import com.rethinkdb.net.ResponsePump;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultConnectionFactory
implements ConnectionSocket.AsyncFactory,
ResponsePump.Factory {
    public static final DefaultConnectionFactory INSTANCE = new DefaultConnectionFactory();

    private DefaultConnectionFactory() {
    }

    @Override
    @NotNull
    public CompletableFuture<ConnectionSocket> newSocketAsync(@NotNull String hostname, int port, @Nullable SSLContext sslContext, @Nullable Long timeoutMs) {
        return CompletableFuture.supplyAsync(() -> new SocketWrapper(hostname, port, sslContext, timeoutMs).connect());
    }

    @Override
    @NotNull
    public ResponsePump newPump(@NotNull ConnectionSocket socket, boolean daemonThreads) {
        return new ThreadResponsePump(socket, daemonThreads);
    }

    private static class ThreadResponsePump
    implements ResponsePump {
        private final AtomicReference<Throwable> shutdownReason = new AtomicReference();
        private final Thread thread;
        private Map<Long, CompletableFuture<Response>> awaiting = new ConcurrentHashMap<Long, CompletableFuture<Response>>();

        public ThreadResponsePump(ConnectionSocket socket, boolean daemon) {
            this.thread = new Thread(() -> {
                while (true) {
                    if (!socket.isOpen()) {
                        this.shutdown(new IOException("Socket closed, exiting response pump."));
                        return;
                    }
                    if (this.awaiting == null) {
                        return;
                    }
                    try {
                        CompletableFuture.supplyAsync(Response.readFromSocket(socket)).handle((response, t) -> {
                            if (t != null) {
                                this.shutdown((Throwable)t);
                            } else {
                                CompletableFuture<Response> awaiter = this.awaiting.remove(response.token);
                                if (awaiter != null) {
                                    awaiter.complete((Response)response);
                                }
                            }
                            return null;
                        });
                    }
                    catch (Exception e) {
                        this.shutdown(e);
                        return;
                    }
                }
            }, "RethinkDB-" + socket + "-ResponsePump");
            this.thread.setDaemon(daemon);
            this.thread.start();
        }

        @Override
        @NotNull
        public CompletableFuture<Response> await(long token) {
            if (this.awaiting == null) {
                throw new ReqlDriverError("Response pump closed.", this.shutdownReason.get());
            }
            CompletableFuture<Response> future = new CompletableFuture<Response>();
            this.awaiting.put(token, future);
            return future;
        }

        @Override
        public boolean isAlive() {
            return this.thread.isAlive();
        }

        private void shutdown(Throwable t) {
            Map<Long, CompletableFuture<Response>> awaiting = this.awaiting;
            this.shutdownReason.compareAndSet(null, t);
            this.awaiting = null;
            this.thread.interrupt();
            if (awaiting != null) {
                awaiting.forEach((token, future) -> future.completeExceptionally(t));
            }
        }

        @Override
        public void shutdownPump() {
            this.shutdown(new Throwable("Shutdown was requested."));
        }

        public String toString() {
            return "ThreadResponsePump";
        }
    }

    private static class SocketWrapper
    implements ConnectionSocket {
        private Socket socket;
        private InputStream inputStream;
        private OutputStream outputStream;
        private final SSLContext sslContext;
        private final Long timeoutMs;
        private final String hostname;
        private final int port;

        SocketWrapper(String hostname, int port, SSLContext sslContext, Long timeoutMs) {
            this.hostname = hostname;
            this.port = port;
            this.sslContext = sslContext;
            this.timeoutMs = timeoutMs;
        }

        SocketWrapper connect() {
            try {
                InetSocketAddress addr = new InetSocketAddress(this.hostname, this.port);
                this.socket = SocketFactory.getDefault().createSocket();
                this.socket.connect(addr, this.timeoutMs == null ? 0 : this.timeoutMs.intValue());
                this.socket.setTcpNoDelay(true);
                this.socket.setKeepAlive(true);
                if (this.sslContext != null) {
                    SSLSocket sslSocket = (SSLSocket)this.sslContext.getSocketFactory().createSocket(this.socket, this.socket.getInetAddress().getHostAddress(), this.socket.getPort(), true);
                    this.inputStream = new DataInputStream(sslSocket.getInputStream());
                    this.outputStream = sslSocket.getOutputStream();
                    sslSocket.startHandshake();
                } else {
                    this.outputStream = this.socket.getOutputStream();
                    this.inputStream = this.socket.getInputStream();
                }
            }
            catch (IOException e) {
                throw new ReqlDriverError("Connection timed out.", e);
            }
            return this;
        }

        @Override
        public void write(@NotNull ByteBuffer buffer) {
            try {
                buffer.flip();
                this.outputStream.write(buffer.array());
            }
            catch (IOException e) {
                throw new ReqlDriverError(e);
            }
        }

        @Override
        @NotNull
        public String readCString(@Nullable Long deadline) {
            Long timeout = deadline == null ? null : Long.valueOf(System.currentTimeMillis() + deadline);
            StringBuilder b = new StringBuilder();
            while (timeout == null || System.currentTimeMillis() < timeout) {
                char c;
                try {
                    int has = this.inputStream.available();
                    if (has < 0) break;
                    if (has == 0) {
                        Thread.yield();
                        continue;
                    }
                    int next = this.inputStream.read();
                    if (next == -1 || (c = (char)next) == '\u0000') {
                        return b.toString();
                    }
                }
                catch (IOException e) {
                    throw new ReqlDriverError(e);
                }
                b.append(c);
            }
            throw new ReqlDriverError("Read timed out.");
        }

        @Override
        @NotNull
        public ByteBuffer read(int length) {
            try {
                int res;
                byte[] buf = new byte[length];
                for (int bytesRead = 0; bytesRead < length; bytesRead += res) {
                    res = this.inputStream.read(buf, bytesRead, length - bytesRead);
                    if (res != -1) continue;
                    throw new ReqlDriverError("Reached the end of the read stream.");
                }
                return ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN);
            }
            catch (IOException e) {
                throw new ReqlDriverError(e);
            }
        }

        @Override
        public boolean isOpen() {
            return this.socket != null && this.socket.isConnected() && !this.socket.isClosed();
        }

        @Override
        public void close() {
            if (this.socket != null && this.isOpen()) {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    throw new ReqlDriverError(e);
                }
            }
        }

        public String toString() {
            return "ConnectionSocket(" + this.hostname + ':' + this.port + ')';
        }
    }
}

