/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.net;

import com.fasterxml.jackson.core.type.TypeReference;
import com.rethinkdb.ast.Query;
import com.rethinkdb.gen.exc.ReqlDriverError;
import com.rethinkdb.gen.exc.ReqlError;
import com.rethinkdb.gen.exc.ReqlRuntimeError;
import com.rethinkdb.gen.proto.ResponseType;
import com.rethinkdb.model.Profile;
import com.rethinkdb.net.Connection;
import com.rethinkdb.net.Response;
import com.rethinkdb.utils.Internals;
import java.io.Closeable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Result<T>
implements Iterator<T>,
Iterable<T>,
Closeable {
    private static final Object NIL = new Object();
    private static final Object END = new Object();
    protected final Connection connection;
    protected final Query query;
    protected final Response sourceResponse;
    protected final TypeReference<T> typeRef;
    protected final Internals.FormatOptions fmt;
    protected final boolean unwrapLists;
    protected FetchMode fetchMode;
    protected final BlockingQueue<Object> rawQueue = new LinkedBlockingQueue<Object>();
    protected final CompletableFuture<Boolean> completed = new CompletableFuture();
    private final AtomicReference<PartialSequence> currentPartial = new AtomicReference();

    public Result(Connection connection, Query query, Response sourceResponse, FetchMode fetchMode, boolean unwrapLists, TypeReference<T> typeRef) {
        this.connection = connection;
        this.query = query;
        this.sourceResponse = sourceResponse;
        this.fetchMode = fetchMode;
        this.typeRef = typeRef;
        this.fmt = Internals.parseFormatOptions(query.globalOptions);
        this.unwrapLists = unwrapLists;
        this.handleFirstResponse();
    }

    public long connectionToken() {
        return this.query.token;
    }

    public int bufferedCount() {
        return this.rawQueue.size();
    }

    public boolean isFeed() {
        return this.sourceResponse.isFeed();
    }

    @Override
    public void close() {
        this.completed.complete(false);
    }

    @NotNull
    public List<T> toList() {
        return this.collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, A> R collect(@NotNull Collector<? super T, A, R> collector) {
        try {
            this.overrideFetchMode(FetchMode.AGGRESSIVE);
            Object container = collector.supplier().get();
            BiConsumer accumulator = collector.accumulator();
            this.forEach(next -> accumulator.accept(container, (Object)next));
            R r = collector.finisher().apply(container);
            return r;
        }
        finally {
            this.close();
        }
    }

    @NotNull
    public Stream<T> stream() {
        return (Stream)StreamSupport.stream(this.overrideFetchMode(FetchMode.AGGRESSIVE).spliterator(), false).onClose(this::close);
    }

    @NotNull
    public Stream<T> parallelStream() {
        return (Stream)StreamSupport.stream(this.overrideFetchMode(FetchMode.AGGRESSIVE).spliterator(), true).onClose(this::close);
    }

    @Override
    public boolean hasNext() {
        return !this.rawQueue.isEmpty() && this.rawQueue.peek() != END || !this.completed.isDone();
    }

    @Nullable
    public T next(long timeout, TimeUnit unit) throws TimeoutException {
        try {
            if (!this.hasNext()) {
                this.throwOnCompleted();
            }
            this.maybeContinue();
            Object next = this.rawQueue.poll(timeout, unit);
            this.maybeContinue();
            if (next == null) {
                throw new TimeoutException("The poll operation timed out.");
            }
            if (next == END) {
                this.rawQueue.offer(END);
                this.throwOnCompleted();
                throw new ReqlDriverError("END reached, but wasn't completed. Please contact devs!");
            }
            if (next == NIL) {
                return null;
            }
            return Internals.toPojo(next, this.typeRef);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public T next() {
        try {
            if (!this.hasNext()) {
                this.throwOnCompleted();
            }
            this.maybeContinue();
            Object next = this.rawQueue.take();
            this.maybeContinue();
            if (next == END) {
                this.rawQueue.offer(END);
                this.throwOnCompleted();
                throw new ReqlDriverError("END reached, but wasn't completed. Please contact devs!");
            }
            if (next == NIL) {
                return null;
            }
            return Internals.toPojo(next, this.typeRef);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public T first() {
        try {
            Object next;
            if (!this.hasNext()) {
                this.throwOnCompleted();
            }
            if ((next = this.rawQueue.take()) == END) {
                this.rawQueue.offer(END);
                this.throwOnCompleted();
                throw new ReqlDriverError("END reached, but wasn't completed. Please contact devs!");
            }
            if (next == NIL) {
                T t = null;
                return t;
            }
            T t = Internals.toPojo(next, this.typeRef);
            return t;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.rawQueue.clear();
            this.close();
        }
    }

    @Nullable
    public T single() {
        try {
            if (!this.hasNext()) {
                this.throwOnCompleted();
            }
            Object next = this.rawQueue.take();
            if (this.hasNext()) {
                throw new IllegalStateException("More than one result.");
            }
            if (next == END) {
                this.rawQueue.offer(END);
                this.throwOnCompleted();
                throw new ReqlDriverError("END reached, but wasn't completed. Please contact devs!");
            }
            if (next == NIL) {
                T t = null;
                return t;
            }
            T t = Internals.toPojo(next, this.typeRef);
            return t;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.rawQueue.clear();
            this.close();
        }
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        try {
            Objects.requireNonNull(action);
            this.overrideFetchMode(FetchMode.AGGRESSIVE);
            while (this.hasNext()) {
                action.accept(this.next());
            }
        }
        finally {
            this.close();
        }
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        this.forEach(action);
    }

    @Nullable
    public Profile profile() {
        return this.currentResponse().profile;
    }

    @NotNull
    public ResponseType responseType() {
        return this.currentResponse().type;
    }

    @NotNull
    public Result<T> overrideFetchMode(FetchMode fetchMode) {
        this.fetchMode = fetchMode;
        this.maybeContinue();
        return this;
    }

    public String toString() {
        return "Result{connection=" + this.connection + ", query=" + this.query + ", firstRes=" + this.sourceResponse + ", completed=" + this.completed + ", currentResponse=" + this.currentResponse() + '}';
    }

    protected Response currentResponse() {
        PartialSequence batch = this.currentPartial.get();
        if (batch != null) {
            return batch.response;
        }
        return this.sourceResponse;
    }

    protected void handleFirstResponse() {
        try {
            ResponseType type = this.sourceResponse.type;
            if (type.equals((Object)ResponseType.WAIT_COMPLETE)) {
                this.completed.complete(true);
                return;
            }
            if (type.equals((Object)ResponseType.SUCCESS_ATOM) || type.equals((Object)ResponseType.SUCCESS_SEQUENCE)) {
                try {
                    this.emitData(this.sourceResponse);
                }
                catch (IndexOutOfBoundsException ex) {
                    throw new ReqlDriverError("Atom response was empty!", ex);
                }
                this.completed.complete(true);
                return;
            }
            if (type.equals((Object)ResponseType.SUCCESS_PARTIAL)) {
                this.currentPartial.set(new PartialSequence(this.sourceResponse));
                this.completed.thenAccept(finished -> {
                    if (!finished.booleanValue()) {
                        this.connection.sendStop(this.sourceResponse.token);
                    }
                    this.connection.loseTrackOf(this);
                });
                this.connection.keepTrackOf(this);
                this.maybeContinue();
                return;
            }
            throw this.sourceResponse.makeError(this.query);
        }
        catch (Exception e) {
            this.completed.completeExceptionally(e);
            throw e;
        }
    }

    protected void throwOnCompleted() {
        if (this.completed.isDone()) {
            try {
                if (this.completed.join().booleanValue()) {
                    throw new NoSuchElementException("No more elements.");
                }
                throw new NoSuchElementException("Result was cancelled.");
            }
            catch (CompletionException e) {
                if (e.getCause() instanceof ReqlError) {
                    throw (ReqlError)e.getCause();
                }
                throw e;
            }
        }
    }

    protected void maybeContinue() {
        PartialSequence partial = this.currentPartial.get();
        if (partial != null) {
            partial.maybeContinue();
        }
    }

    protected void onConnectionClosed() {
        this.currentPartial.set(new PartialSequence(new Response(this.query.token, ResponseType.SUCCESS_SEQUENCE)));
        this.completed.completeExceptionally(new ReqlRuntimeError("Connection is closed."));
    }

    protected int emitData(Response res) {
        this.throwOnCompleted();
        int count = 0;
        for (Object each : (List)Internals.convertPseudotypes(res.data, this.fmt)) {
            if (this.unwrapLists && res.type.equals((Object)ResponseType.SUCCESS_ATOM) && each instanceof List) {
                for (Object o : (List)each) {
                    this.rawQueue.offer(o == null ? NIL : o);
                    ++count;
                }
                continue;
            }
            this.rawQueue.offer(each == null ? NIL : each);
            ++count;
        }
        return count;
    }

    public static enum FetchMode {
        AGGRESSIVE{

            @Override
            public boolean shouldContinue(int size, int requestSize) {
                return true;
            }
        }
        ,
        PREEMPTIVE_HALF{

            @Override
            public boolean shouldContinue(int size, int requestSize) {
                return size <= requestSize / 2;
            }
        }
        ,
        PREEMPTIVE_THIRD{

            @Override
            public boolean shouldContinue(int size, int requestSize) {
                return size <= requestSize / 3;
            }
        }
        ,
        PREEMPTIVE_FOURTH{

            @Override
            public boolean shouldContinue(int size, int requestSize) {
                return size <= requestSize / 4;
            }
        }
        ,
        PREEMPTIVE_FIFTH{

            @Override
            public boolean shouldContinue(int size, int requestSize) {
                return size <= requestSize / 5;
            }
        }
        ,
        PREEMPTIVE_SIXTH{

            @Override
            public boolean shouldContinue(int size, int requestSize) {
                return size <= requestSize / 6;
            }
        }
        ,
        PREEMPTIVE_SEVENTH{

            @Override
            public boolean shouldContinue(int size, int requestSize) {
                return size <= requestSize / 7;
            }
        }
        ,
        PREEMPTIVE_EIGHTH{

            @Override
            public boolean shouldContinue(int size, int requestSize) {
                return size <= requestSize / 8;
            }
        }
        ,
        LAZY{

            @Override
            public boolean shouldContinue(int size, int requestSize) {
                return size == 0;
            }
        };


        public abstract boolean shouldContinue(int var1, int var2);

        @Nullable
        public static FetchMode fromString(String s) {
            try {
                return FetchMode.valueOf(s.toUpperCase());
            }
            catch (RuntimeException ignored) {
                return null;
            }
        }
    }

    private class PartialSequence {
        protected final Response response;
        protected final int emitted;
        protected final boolean last;
        protected final AtomicBoolean continued = new AtomicBoolean();

        private PartialSequence(Response response) {
            this.response = response;
            if (response.type.equals((Object)ResponseType.SUCCESS_PARTIAL)) {
                this.last = false;
                this.emitted = this.tryEmitData();
                this.maybeContinue();
            } else if (response.type.equals((Object)ResponseType.SUCCESS_SEQUENCE)) {
                this.last = true;
                this.emitted = this.tryEmitData();
                Result.this.completed.complete(true);
                Result.this.rawQueue.offer(END);
            } else {
                this.last = true;
                Result.this.completed.completeExceptionally(response.makeError(Result.this.query));
                Result.this.rawQueue.offer(END);
                this.emitted = 0;
            }
        }

        protected void maybeContinue() {
            int remaining = Result.this.rawQueue.size();
            if (!Result.this.completed.isDone() && !this.last && Result.this.fetchMode.shouldContinue(remaining, this.emitted)) {
                this.continueResponse();
            }
        }

        private int tryEmitData() {
            try {
                return Result.this.emitData(this.response);
            }
            catch (Exception e) {
                Result.this.completed.completeExceptionally(e);
                Result.this.rawQueue.offer(END);
                return 0;
            }
        }

        private void continueResponse() {
            if (!this.continued.getAndSet(true)) {
                Result.this.connection.sendContinue(this.response.token).whenComplete((continued, t) -> {
                    if (t == null) {
                        Result.this.currentPartial.set(new PartialSequence((Response)continued));
                    } else {
                        Result.this.completed.completeExceptionally((Throwable)t);
                        Result.this.rawQueue.offer(END);
                    }
                });
            }
        }
    }
}

