/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.rethinkdb.model.GroupedResult;
import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class Types {
    private Types() {
    }

    public static <T> TypeReference<T> of(Class<T> type) {
        return new BuiltTypeRef(Objects.requireNonNull(type, "type"));
    }

    public static <T> TypeReference<List<T>> listOf(Class<T> type) {
        return new BuiltTypeRef<List<T>>(new BuiltParametrizedType(List.class, Objects.requireNonNull(type, "type")));
    }

    public static <T> TypeReference<List<T>> listOf(TypeReference<T> type) {
        return new BuiltTypeRef<List<T>>(new BuiltParametrizedType(List.class, Objects.requireNonNull(type, "type").getType()));
    }

    public static <T> TypeReference<Set<T>> setOf(Class<T> type) {
        return new BuiltTypeRef<Set<T>>(new BuiltParametrizedType(Set.class, Objects.requireNonNull(type, "type")));
    }

    public static <T> TypeReference<Set<T>> setOf(TypeReference<T> type) {
        return new BuiltTypeRef<Set<T>>(new BuiltParametrizedType(Set.class, Objects.requireNonNull(type, "type").getType()));
    }

    public static <K, V> TypeReference<Map<K, V>> mapOf(Class<K> keyType, Class<V> valueType) {
        return new BuiltTypeRef<Map<K, V>>(new BuiltParametrizedType(Map.class, Objects.requireNonNull(keyType, "keyType"), Objects.requireNonNull(valueType, "valueType")));
    }

    public static <K, V> TypeReference<Map<K, V>> mapOf(TypeReference<K> keyType, Class<V> valueType) {
        return new BuiltTypeRef<Map<K, V>>(new BuiltParametrizedType(Map.class, Objects.requireNonNull(keyType, "keyType").getType(), Objects.requireNonNull(valueType, "valueType")));
    }

    public static <K, V> TypeReference<Map<K, V>> mapOf(Class<K> keyType, TypeReference<V> valueType) {
        return new BuiltTypeRef<Map<K, V>>(new BuiltParametrizedType(Map.class, Objects.requireNonNull(keyType, "keyType"), Objects.requireNonNull(valueType, "valueType").getType()));
    }

    public static <K, V> TypeReference<Map<K, V>> mapOf(TypeReference<K> keyType, TypeReference<V> valueType) {
        return new BuiltTypeRef<Map<K, V>>(new BuiltParametrizedType(Map.class, Objects.requireNonNull(keyType, "keyType").getType(), Objects.requireNonNull(valueType, "valueType").getType()));
    }

    public static <K, V> TypeReference<GroupedResult<K, V>> groupOf(Class<K> keyType, Class<V> valueType) {
        return new BuiltTypeRef<GroupedResult<K, V>>(new BuiltParametrizedType(GroupedResult.class, Objects.requireNonNull(keyType, "keyType"), Objects.requireNonNull(valueType, "valueType")));
    }

    public static <K, V> TypeReference<GroupedResult<K, V>> groupOf(TypeReference<K> keyType, Class<V> valueType) {
        return new BuiltTypeRef<GroupedResult<K, V>>(new BuiltParametrizedType(GroupedResult.class, Objects.requireNonNull(keyType, "keyType").getType(), Objects.requireNonNull(valueType, "valueType")));
    }

    public static <K, V> TypeReference<GroupedResult<K, V>> groupOf(Class<K> keyType, TypeReference<V> valueType) {
        return new BuiltTypeRef<GroupedResult<K, V>>(new BuiltParametrizedType(GroupedResult.class, Objects.requireNonNull(keyType, "keyType"), Objects.requireNonNull(valueType, "valueType").getType()));
    }

    public static <K, V> TypeReference<GroupedResult<K, V>> groupOf(TypeReference<K> keyType, TypeReference<V> valueType) {
        return new BuiltTypeRef<GroupedResult<K, V>>(new BuiltParametrizedType(GroupedResult.class, Objects.requireNonNull(keyType, "keyType").getType(), Objects.requireNonNull(valueType, "valueType").getType()));
    }

    private static class BuiltParametrizedType
    implements ParameterizedType {
        private final Class<?> type;
        private final Type[] params;

        public BuiltParametrizedType(Class<?> type, Type ... params) {
            if (params.length != type.getTypeParameters().length) {
                throw new MalformedParameterizedTypeException();
            }
            this.type = type;
            this.params = params;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return (Type[])this.params.clone();
        }

        @Override
        public Type getRawType() {
            return this.type;
        }

        @Override
        public Type getOwnerType() {
            return this.type.getDeclaringClass();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType that = (ParameterizedType)o;
            return Objects.equals(this.type, that.getRawType()) && Objects.equals(this.type.getDeclaringClass(), that.getOwnerType()) && Arrays.equals(this.params, that.getActualTypeArguments());
        }

        public int hashCode() {
            return Arrays.hashCode(this.params) ^ Objects.hashCode(this.type) ^ Objects.hashCode(this.type.getDeclaringClass());
        }

        public String toString() {
            return this.type.getName() + Arrays.stream(this.params).map(Type::getTypeName).collect(Collectors.joining(", ", "<", ">"));
        }
    }

    private static class BuiltTypeRef<T>
    extends TypeReference<T> {
        private final Type type;

        private BuiltTypeRef(Type type) {
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }
    }
}

