/*
 * Decompiled with CFR 0.152.
 */
package com.rexsl.page.auth;

import com.jcabi.aspects.Cacheable;
import com.jcabi.aspects.Loggable;
import com.jcabi.aspects.aj.MethodCacher;
import com.jcabi.aspects.aj.MethodLogger;
import com.jcabi.aspects.aj.MethodValidator;
import com.jcabi.log.Logger;
import com.rexsl.page.BasePage;
import com.rexsl.page.CookieBuilder;
import com.rexsl.page.Inset;
import com.rexsl.page.JaxbBundle;
import com.rexsl.page.Link;
import com.rexsl.page.Resource;
import com.rexsl.page.auth.AuthException;
import com.rexsl.page.auth.AuthInset$AjcClosure1;
import com.rexsl.page.auth.AuthInset$AjcClosure11;
import com.rexsl.page.auth.AuthInset$AjcClosure13;
import com.rexsl.page.auth.AuthInset$AjcClosure15;
import com.rexsl.page.auth.AuthInset$AjcClosure3;
import com.rexsl.page.auth.AuthInset$AjcClosure5;
import com.rexsl.page.auth.AuthInset$AjcClosure7;
import com.rexsl.page.auth.AuthInset$AjcClosure9;
import com.rexsl.page.auth.Encrypted;
import com.rexsl.page.auth.Identity;
import com.rexsl.page.auth.Provider;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Loggable(value=1)
public final class AuthInset
implements Inset {
    private static final String AUTH_COOKIE = "Rexsl-Auth";
    private static final String LOGOUT_FLAG = "rexsl-logout";
    private final transient Resource resource;
    private final transient String key;
    private final transient Set<Provider> providers;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    public AuthInset(@NotNull Resource res, @NotNull String sec) {
        Resource resource = res;
        String string = sec;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)resource, (Object)string);
        MethodValidator.aspectOf().beforeCtor(joinPoint);
        this.providers = new HashSet<Provider>(0);
        this.resource = res;
        this.key = sec;
    }

    public static String encrypt(@NotNull Identity identity, @NotNull String key) {
        Identity identity2 = identity;
        String string = key;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)identity2, (Object)string);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{identity2, string, joinPoint};
            return (String)MethodLogger.aspectOf().wrapClass(new AuthInset$AjcClosure1(objectArray).linkClosureAndJoinPoint(65536));
        }
        return AuthInset.encrypt_aroundBody0(identity2, string, joinPoint);
    }

    public String encrypt(@NotNull Identity identity) {
        Identity identity2 = identity;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)identity2);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, identity2, joinPoint};
            return (String)MethodLogger.aspectOf().wrapClass(new AuthInset$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
        }
        return AuthInset.encrypt_aroundBody2(this, identity2, joinPoint);
    }

    public AuthInset with(@NotNull Provider prov) {
        Provider provider = prov;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)provider);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, provider, joinPoint};
            return (AuthInset)MethodLogger.aspectOf().wrapClass(new AuthInset$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
        }
        return AuthInset.with_aroundBody4(this, provider, joinPoint);
    }

    @Cacheable(lifetime=1, unit=TimeUnit.SECONDS)
    public Identity identity() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (Identity)MethodCacher.aspectOf().cache(new AuthInset$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    public void render(@NotNull BasePage<?, ?> page, @NotNull Response.ResponseBuilder builder) {
        BasePage<?, ?> basePage = page;
        Response.ResponseBuilder responseBuilder = builder;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, basePage, (Object)responseBuilder);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, basePage, responseBuilder, joinPoint};
            MethodLogger.aspectOf().wrapClass(new AuthInset$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        AuthInset.render_aroundBody10(this, basePage, responseBuilder, joinPoint);
    }

    public NewCookie cookie(Identity identity) {
        Identity identity2 = identity;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)identity2);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, identity2, joinPoint};
            return (NewCookie)MethodLogger.aspectOf().wrapClass(new AuthInset$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
        }
        return AuthInset.cookie_aroundBody12(this, identity2, joinPoint);
    }

    @Cacheable.FlushAfter
    public NewCookie logout() {
        NewCookie newCookie;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        try {
            if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
                Object[] objectArray = new Object[]{this, joinPoint};
                newCookie = (NewCookie)MethodLogger.aspectOf().wrapClass(new AuthInset$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648));
            } else {
                newCookie = AuthInset.logout_aroundBody14(this, joinPoint);
            }
        }
        finally {
            MethodCacher.aspectOf().postflush(joinPoint);
        }
        return newCookie;
    }

    private Identity ofProviders() {
        Identity identity = Identity.ANONYMOUS;
        for (Provider prov : this.providers) {
            try {
                identity = prov.identity();
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
            if (identity.equals(Identity.ANONYMOUS)) continue;
            if (!prov.getClass().isAnnotationPresent(Provider.Redirect.class)) break;
            throw new AuthException(Response.status((int)303).location(this.resource.uriInfo().getRequestUriBuilder().replaceQuery("").build(new Object[0])).cookie(new NewCookie[]{this.cookie(identity)}).build(), Logger.format((String)"redirecting because of @Provider.Redirect at %[type]s", (Object[])new Object[]{prov}));
        }
        return identity;
    }

    private Identity ofCookies() {
        Identity identity = Identity.ANONYMOUS;
        if (this.resource.httpHeaders().getCookies().containsKey(AUTH_COOKIE)) {
            String cookie = ((Cookie)this.resource.httpHeaders().getCookies().get(AUTH_COOKIE)).getValue();
            try {
                identity = new Identity.Simple(Encrypted.parse(cookie, this.key));
            }
            catch (Encrypted.DecryptionException ex) {
                Logger.warn((Object)this, (String)"Failed to decrypt '%s' from '%s' to '%s': %[exception]s", (Object[])new Object[]{cookie, this.resource.httpServletRequest().getRemoteAddr(), this.resource.httpServletRequest().getRequestURI(), ex});
            }
        } else {
            Logger.debug((Object)this, (String)"cookie '%s' not found among %[list]s", (Object[])new Object[]{AUTH_COOKIE, this.resource.httpHeaders().getCookies().keySet()});
        }
        return identity;
    }

    public String toString() {
        return "AuthInset(resource=" + this.resource + ", key=" + this.key + ", providers=" + this.providers + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthInset)) {
            return false;
        }
        AuthInset other = (AuthInset)o;
        Resource this$resource = this.resource;
        Resource other$resource = other.resource;
        if (this$resource == null ? other$resource != null : !this$resource.equals(other$resource)) {
            return false;
        }
        String this$key = this.key;
        String other$key = other.key;
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    public int hashCode() {
        int PRIME = 277;
        int result = 1;
        Resource $resource = this.resource;
        result = result * 277 + ($resource == null ? 0 : $resource.hashCode());
        String $key = this.key;
        result = result * 277 + ($key == null ? 0 : $key.hashCode());
        return result;
    }

    static {
        AuthInset.ajc$preClinit();
    }

    static /* synthetic */ String encrypt_aroundBody0(Identity identity, String key, JoinPoint joinPoint) {
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        return new Encrypted(identity, key).cookie();
    }

    static /* synthetic */ String encrypt_aroundBody2(AuthInset ajc$this, Identity identity, JoinPoint joinPoint) {
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        return AuthInset.encrypt(identity, ajc$this.key);
    }

    static /* synthetic */ AuthInset with_aroundBody4(AuthInset ajc$this, Provider prov, JoinPoint joinPoint) {
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        ajc$this.providers.add(prov);
        return ajc$this;
    }

    static /* synthetic */ Identity identity_aroundBody6(AuthInset ajc$this, JoinPoint joinPoint) {
        Identity identity = ajc$this.ofProviders();
        if (identity.equals(Identity.ANONYMOUS)) {
            identity = ajc$this.ofCookies();
        }
        return identity;
    }

    static /* synthetic */ Identity identity_aroundBody8(AuthInset authInset, JoinPoint joinPoint) {
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{authInset, joinPoint};
            return (Identity)MethodLogger.aspectOf().wrapClass(new AuthInset$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
        }
        return AuthInset.identity_aroundBody6(authInset, joinPoint);
    }

    static /* synthetic */ void render_aroundBody10(AuthInset ajc$this, BasePage page, Response.ResponseBuilder builder, JoinPoint joinPoint) {
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        Identity identity = ajc$this.identity();
        if (identity.equals(Identity.ANONYMOUS)) {
            for (Provider prov : ajc$this.providers) {
                if (!(prov instanceof Provider.Visible)) continue;
                page.link(((Provider.Visible)Provider.Visible.class.cast(prov)).link());
            }
        } else {
            page.append(new JaxbBundle("identity").add("urn", identity.urn().toString()).up().add("name", identity.name()).up().add("photo", identity.photo().toString()).up().add("token", ajc$this.encrypt(identity)).up());
            page.link(new Link("auth-logout", ajc$this.resource.uriInfo().getRequestUriBuilder().clone().queryParam(LOGOUT_FLAG, new Object[]{true}).build(new Object[0])));
            builder.cookie(new NewCookie[]{ajc$this.cookie(identity)});
            builder.header("X-Rexsl-Identity", (Object)identity.urn());
        }
        if (ajc$this.resource.uriInfo().getQueryParameters().containsKey((Object)LOGOUT_FLAG)) {
            throw new AuthException(Response.status((int)303).location(ajc$this.resource.uriInfo().getRequestUriBuilder().replaceQuery("").build(new Object[0])).cookie(new NewCookie[]{ajc$this.logout()}).build(), String.format("redirecting because of '%s' flag in HTTP query", LOGOUT_FLAG));
        }
    }

    static /* synthetic */ NewCookie cookie_aroundBody12(AuthInset ajc$this, Identity identity, JoinPoint joinPoint) {
        return new CookieBuilder(ajc$this.resource.uriInfo().getBaseUri()).name(AUTH_COOKIE).value(new Encrypted(identity, ajc$this.key).cookie()).temporary().build();
    }

    static /* synthetic */ NewCookie logout_aroundBody14(AuthInset ajc$this, JoinPoint joinPoint) {
        return new CookieBuilder(ajc$this.resource.uriInfo().getBaseUri()).name(AUTH_COOKIE).build();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AuthInset.java", AuthInset.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "encrypt", "com.rexsl.page.auth.AuthInset", "com.rexsl.page.auth.Identity:java.lang.String", "identity:key", "", "java.lang.String"), 110);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "encrypt", "com.rexsl.page.auth.AuthInset", "com.rexsl.page.auth.Identity", "identity", "", "java.lang.String"), 120);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "with", "com.rexsl.page.auth.AuthInset", "com.rexsl.page.auth.Provider", "prov", "", "com.rexsl.page.auth.AuthInset"), 129);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "identity", "com.rexsl.page.auth.AuthInset", "", "", "", "com.rexsl.page.auth.Identity"), 140);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "render", "com.rexsl.page.auth.AuthInset", "com.rexsl.page.BasePage:javax.ws.rs.core.Response$ResponseBuilder", "page:builder", "", "void"), 150);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cookie", "com.rexsl.page.auth.AuthInset", "com.rexsl.page.auth.Identity", "identity", "", "javax.ws.rs.core.NewCookie"), 203);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "logout", "com.rexsl.page.auth.AuthInset", "", "", "", "javax.ws.rs.core.NewCookie"), 228);
        ajc$tjp_7 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.rexsl.page.auth.AuthInset", "com.rexsl.page.Resource:java.lang.String", "res:sec", ""), 97);
    }
}

