/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.graphhopper.json.geo.GeoJsonPolygon;
import com.graphhopper.json.geo.JsonFeature;
import com.graphhopper.json.geo.LineString;
import com.graphhopper.json.geo.Point;
import com.graphhopper.routing.util.spatialrules.Polygon;
import com.graphhopper.util.shapes.BBox;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.UUID;

public class FeatureJsonDeserializer
implements JsonDeserializer<JsonFeature> {
    public JsonFeature deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        try {
            JsonObject geometryJson;
            JsonObject obj = json.getAsJsonObject();
            String strType = null;
            Map properties = null;
            BBox bbox = null;
            LineString geometry = null;
            String id = obj.has("id") ? obj.get("id").getAsString() : UUID.randomUUID().toString();
            if (obj.has("properties")) {
                properties = (Map)context.deserialize(obj.get("properties"), Map.class);
            }
            if (obj.has("bbox")) {
                bbox = this.parseBBox(obj.get("bbox").getAsJsonArray());
            }
            if (obj.has("geometry") && (geometryJson = obj.get("geometry").getAsJsonObject()).has("coordinates")) {
                if (!geometryJson.has("type")) {
                    throw new IllegalArgumentException("No type for non-empty coordinates specified");
                }
                strType = (String)context.deserialize(geometryJson.get("type"), String.class);
                if ("Point".equals(strType)) {
                    JsonArray arr = geometryJson.get("coordinates").getAsJsonArray();
                    double lon = arr.get(0).getAsDouble();
                    double lat = arr.get(1).getAsDouble();
                    geometry = arr.size() == 3 ? new Point(lat, lon, arr.get(2).getAsDouble()) : new Point(lat, lon);
                } else if ("MultiPoint".equals(strType)) {
                    geometry = this.parseLineString(geometryJson);
                } else if ("LineString".equals(strType)) {
                    geometry = this.parseLineString(geometryJson);
                } else if ("Polygon".equals(strType)) {
                    geometry = this.parsePolygonString(geometryJson);
                } else if ("MultiPolygon".equals(strType)) {
                    geometry = this.parsePolygonString(geometryJson);
                } else {
                    throw new IllegalArgumentException("Coordinates type " + strType + " not yet supported");
                }
            }
            return new JsonFeature(id, strType, bbox, geometry, properties);
        }
        catch (Exception ex) {
            throw new JsonParseException("Problem parsing JSON feature " + json, (Throwable)ex);
        }
    }

    LineString parseLineString(JsonObject geometry) {
        JsonArray arr = geometry.get("coordinates").getAsJsonArray();
        boolean is3D = arr.size() == 0 || arr.get(0).getAsJsonArray().size() == 3;
        LineString lineString = new LineString(arr.size(), is3D);
        for (int i = 0; i < arr.size(); ++i) {
            JsonArray pointArr = arr.get(i).getAsJsonArray();
            double lon = pointArr.get(0).getAsDouble();
            double lat = pointArr.get(1).getAsDouble();
            if (pointArr.size() == 3) {
                lineString.add(lat, lon, pointArr.get(2).getAsDouble());
                continue;
            }
            lineString.add(lat, lon);
        }
        return lineString;
    }

    GeoJsonPolygon parsePolygonString(JsonObject geometry) {
        JsonArray arr = geometry.get("coordinates").getAsJsonArray();
        GeoJsonPolygon geoJsonPolygon = new GeoJsonPolygon();
        if (geometry.get("type").getAsString().equals("Polygon")) {
            geoJsonPolygon.addPolygon(this.parseSinglePolygonCoordinates(arr));
        } else {
            for (int i = 0; i < arr.size(); ++i) {
                geoJsonPolygon.addPolygon(this.parseSinglePolygonCoordinates(arr.get(i).getAsJsonArray()));
            }
        }
        return geoJsonPolygon;
    }

    private Polygon parseSinglePolygonCoordinates(JsonArray arr) {
        if (arr.size() == 0) {
            throw new IllegalStateException("The passed Array should be of format: [[[coords1],[coords2],....[coordsN]]]");
        }
        JsonArray polygonArr = arr.get(0).getAsJsonArray();
        double[] lats = new double[polygonArr.size()];
        double[] lons = new double[polygonArr.size()];
        for (int i = 0; i < polygonArr.size(); ++i) {
            JsonArray pointArr = polygonArr.get(i).getAsJsonArray();
            lons[i] = pointArr.get(0).getAsDouble();
            lats[i] = pointArr.get(1).getAsDouble();
        }
        return new Polygon(lats, lons);
    }

    private BBox parseBBox(JsonArray arr) {
        if (arr.size() == 6) {
            double minLon = arr.get(0).getAsDouble();
            double minLat = arr.get(1).getAsDouble();
            double minEle = arr.get(2).getAsDouble();
            double maxLon = arr.get(3).getAsDouble();
            double maxLat = arr.get(4).getAsDouble();
            double maxEle = arr.get(5).getAsDouble();
            return new BBox(minLon, maxLon, minLat, maxLat, minEle, maxEle);
        }
        if (arr.size() == 4) {
            double minLon = arr.get(0).getAsDouble();
            double minLat = arr.get(1).getAsDouble();
            double maxLon = arr.get(2).getAsDouble();
            double maxLat = arr.get(3).getAsDouble();
            return new BBox(minLon, maxLon, minLat, maxLat);
        }
        throw new IllegalArgumentException("Illegal array dimension (" + arr.size() + ") of bbox " + arr.toString());
    }
}

