/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.json;

import com.graphhopper.json.GHJson;
import com.graphhopper.json.geo.JsonFeatureCollection;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.storage.change.ChangeGraphHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.Reader;
import java.util.Collection;

public class JsonFeatureConverter {
    private final ChangeGraphHelper changeGraphHelper;
    private final GHJson ghson;
    private final EncodingManager encodingManager;

    public JsonFeatureConverter(GHJson ghson, ChangeGraphHelper changeGraphHelper, EncodingManager encodingManager) {
        this.ghson = ghson;
        this.changeGraphHelper = changeGraphHelper;
        this.encodingManager = encodingManager;
    }

    public long applyChanges(String fileOrFolderStr) {
        File fileOrFolder = new File(fileOrFolderStr);
        try {
            File[] fList;
            if (fileOrFolder.isFile()) {
                return this.applyChanges(new FileReader(fileOrFolder));
            }
            long sum = 0L;
            for (File f : fList = new File(fileOrFolderStr).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".json");
                }
            })) {
                sum += this.applyChanges(new FileReader(f));
            }
            return sum;
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public long applyChanges(Reader reader) {
        JsonFeatureCollection data = (JsonFeatureCollection)this.ghson.fromJson(reader, JsonFeatureCollection.class);
        return this.changeGraphHelper.applyChanges(this.encodingManager, (Collection)data.getFeatures());
    }
}

