/*
   Copyright (c) 2013 Emitrom LLC. All rights reserved. 
   For licensing questions, please contact us at licensing@emitrom.com

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */

package com.emitrom.lienzo.client.core.animation.positioning;

import com.emitrom.lienzo.client.core.types.Point2D;

public abstract class AbstractRadialPositioningCalculator implements IPositioningCalculator
{
    @Override
    public final Point2D calculate(final double percent)
    {
        final double r = getRadius();

        final double a = ((Math.PI * 2) * percent);

        return new Point2D(getX() + Math.cos(a) * r, getY() + Math.sin(a) * r);
    }

    public abstract double getX();

    public abstract double getY();

    public abstract double getRadius();
}
