/*
 * Decompiled with CFR 0.152.
 */
package com.ripple.cryptoconditions;

import com.ripple.cryptoconditions.Condition;
import com.ripple.cryptoconditions.CryptoConditionType;
import com.ripple.cryptoconditions.Ed25519Sha256Condition;
import com.ripple.cryptoconditions.Ed25519Sha256Fulfillment;
import com.ripple.cryptoconditions.Fulfillment;
import com.ripple.cryptoconditions.PrefixSha256Condition;
import com.ripple.cryptoconditions.PrefixSha256Fulfillment;
import com.ripple.cryptoconditions.PreimageSha256Condition;
import com.ripple.cryptoconditions.PreimageSha256Fulfillment;
import com.ripple.cryptoconditions.RsaSha256Condition;
import com.ripple.cryptoconditions.RsaSha256Fulfillment;
import com.ripple.cryptoconditions.ThresholdSha256Condition;
import com.ripple.cryptoconditions.ThresholdSha256Fulfillment;
import com.ripple.cryptoconditions.der.DerEncodingException;
import com.ripple.cryptoconditions.der.DerInputStream;
import com.ripple.cryptoconditions.der.DerTag;
import com.ripple.cryptoconditions.utils.UnsignedBigInteger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;

public class CryptoConditionReader {
    public static final String ED_25519 = "Ed25519";

    public static Condition readCondition(byte[] buffer) throws DerEncodingException {
        return CryptoConditionReader.readCondition(buffer, 0, buffer.length);
    }

    public static Condition readCondition(byte[] buffer, int offset, int length) throws DerEncodingException {
        ByteArrayInputStream bais = new ByteArrayInputStream(buffer, offset, length);
        DerInputStream in = new DerInputStream(bais);
        try {
            Condition condition = CryptoConditionReader.readCondition(in);
            return condition;
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
        }
    }

    public static Condition readCondition(DerInputStream in) throws DerEncodingException, IOException {
        return CryptoConditionReader.readCondition(in, new AtomicInteger());
    }

    public static Condition readCondition(DerInputStream in, AtomicInteger bytesRead) throws DerEncodingException, IOException {
        int tag = in.readTag(bytesRead, DerTag.CONSTRUCTED, DerTag.TAGGED);
        CryptoConditionType type = CryptoConditionType.valueOf(tag);
        int length = in.readLength(bytesRead);
        AtomicInteger innerBytesRead = new AtomicInteger();
        byte[] fingerprint = in.readTaggedObject(0, length - innerBytesRead.get(), innerBytesRead).getValue();
        long cost = new BigInteger(in.readTaggedObject(1, length - innerBytesRead.get(), innerBytesRead).getValue()).longValue();
        EnumSet<CryptoConditionType> subtypes = null;
        if (type == CryptoConditionType.PREFIX_SHA256 || type == CryptoConditionType.THRESHOLD_SHA256) {
            subtypes = CryptoConditionType.getEnumOfTypesFromBitString(in.readTaggedObject(2, length - innerBytesRead.get(), innerBytesRead).getValue());
        }
        bytesRead.addAndGet(innerBytesRead.get());
        switch (type) {
            case PREIMAGE_SHA256: {
                return PreimageSha256Condition.fromCostAndFingerprint(cost, fingerprint);
            }
            case PREFIX_SHA256: {
                return PrefixSha256Condition.fromCostAndFingerprint(cost, fingerprint, subtypes);
            }
            case THRESHOLD_SHA256: {
                return ThresholdSha256Condition.fromCostAndFingerprint(cost, fingerprint, subtypes);
            }
            case RSA_SHA256: {
                return RsaSha256Condition.fromCostAndFingerprint(cost, fingerprint);
            }
            case ED25519_SHA256: {
                return Ed25519Sha256Condition.fromCostAndFingerprint(fingerprint);
            }
        }
        throw new DerEncodingException("Unknown condition type: " + (Object)((Object)type));
    }

    public static Fulfillment readFulfillment(byte[] buffer) throws DerEncodingException {
        return CryptoConditionReader.readFulfillment(buffer, 0, buffer.length);
    }

    public static Fulfillment readFulfillment(byte[] buffer, int offset, int length) throws DerEncodingException {
        ByteArrayInputStream bais = new ByteArrayInputStream(buffer, offset, length);
        DerInputStream in = new DerInputStream(bais);
        try {
            Fulfillment fulfillment = CryptoConditionReader.readFulfillment(in);
            return fulfillment;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public static Fulfillment readFulfillment(DerInputStream in) throws DerEncodingException, IOException {
        return CryptoConditionReader.readFulfillment(in, new AtomicInteger());
    }

    public static Fulfillment readFulfillment(DerInputStream in, AtomicInteger bytesRead) throws DerEncodingException, IOException {
        int tag = in.readTag(bytesRead, DerTag.CONSTRUCTED, DerTag.TAGGED);
        CryptoConditionType type = CryptoConditionType.valueOf(tag);
        int length = in.readLength(bytesRead);
        if (length == 0) {
            throw new DerEncodingException("Encountered an empty fulfillment.");
        }
        AtomicInteger innerBytesRead = new AtomicInteger();
        switch (type) {
            case PREIMAGE_SHA256: {
                byte[] preimage = in.readTaggedObject(0, length - innerBytesRead.get(), innerBytesRead).getValue();
                bytesRead.addAndGet(innerBytesRead.get());
                return PreimageSha256Fulfillment.from(preimage);
            }
            case PREFIX_SHA256: {
                byte[] prefix = in.readTaggedObject(0, length - innerBytesRead.get(), innerBytesRead).getValue();
                long maxMessageLength = new BigInteger(in.readTaggedObject(1, length - innerBytesRead.get(), innerBytesRead).getValue()).longValue();
                in.readTag(2, innerBytesRead, DerTag.CONSTRUCTED, DerTag.TAGGED);
                in.readLength(innerBytesRead);
                Fulfillment subfulfillment = CryptoConditionReader.readFulfillment(in, innerBytesRead);
                bytesRead.addAndGet(innerBytesRead.get());
                return PrefixSha256Fulfillment.from(prefix, maxMessageLength, subfulfillment);
            }
            case THRESHOLD_SHA256: {
                ArrayList<Fulfillment> subfulfillments = new ArrayList<Fulfillment>();
                tag = in.readTag(innerBytesRead, DerTag.CONSTRUCTED, DerTag.TAGGED);
                length = in.readLength(innerBytesRead);
                if (tag == 0) {
                    AtomicInteger subfulfillmentsBytesRead = new AtomicInteger();
                    while (subfulfillmentsBytesRead.get() < length) {
                        subfulfillments.add(CryptoConditionReader.readFulfillment(in, subfulfillmentsBytesRead));
                    }
                    innerBytesRead.addAndGet(subfulfillmentsBytesRead.get());
                    in.readTag(1, innerBytesRead, DerTag.CONSTRUCTED, DerTag.TAGGED);
                    length = in.readLength(innerBytesRead);
                } else if (tag != 1) {
                    throw new DerEncodingException("Expected tag: 1, got: " + tag);
                }
                ArrayList<Condition> subconditions = new ArrayList<Condition>();
                AtomicInteger subconditionsBytesRead = new AtomicInteger();
                while (subconditionsBytesRead.get() < length) {
                    subconditions.add(CryptoConditionReader.readCondition(in, subconditionsBytesRead));
                }
                innerBytesRead.addAndGet(subconditionsBytesRead.get());
                bytesRead.addAndGet(innerBytesRead.get());
                return ThresholdSha256Fulfillment.from(subconditions, subfulfillments);
            }
            case RSA_SHA256: {
                BigInteger modulus = UnsignedBigInteger.fromUnsignedByteArray(in.readTaggedObject(0, length - innerBytesRead.get(), innerBytesRead).getValue());
                byte[] rsaSignature = in.readTaggedObject(1, length - innerBytesRead.get(), innerBytesRead).getValue();
                bytesRead.addAndGet(innerBytesRead.get());
                RSAPublicKeySpec rsaSpec = new RSAPublicKeySpec(modulus, RsaSha256Fulfillment.PUBLIC_EXPONENT);
                try {
                    KeyFactory rsaKeyFactory = KeyFactory.getInstance("RSA");
                    PublicKey publicKey = rsaKeyFactory.generatePublic(rsaSpec);
                    return RsaSha256Fulfillment.from((RSAPublicKey)publicKey, rsaSignature);
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                    throw new RuntimeException("Error creating RSA key.", e);
                }
            }
            case ED25519_SHA256: {
                byte[] ed25519key = in.readTaggedObject(0, length - innerBytesRead.get(), innerBytesRead).getValue();
                byte[] ed25519Signature = in.readTaggedObject(1, length - innerBytesRead.get(), innerBytesRead).getValue();
                bytesRead.addAndGet(innerBytesRead.get());
                EdDSAPublicKeySpec ed25519spec = new EdDSAPublicKeySpec(ed25519key, (EdDSAParameterSpec)EdDSANamedCurveTable.getByName((String)ED_25519));
                EdDSAPublicKey ed25519PublicKey = new EdDSAPublicKey(ed25519spec);
                return Ed25519Sha256Fulfillment.from(ed25519PublicKey, ed25519Signature);
            }
        }
        throw new DerEncodingException("Unrecogized condition type: " + (Object)((Object)type));
    }
}

