/*
 * Decompiled with CFR 0.152.
 */
package com.ripple.cryptoconditions;

import com.ripple.cryptoconditions.CompoundCondition;
import com.ripple.cryptoconditions.Condition;
import com.ripple.cryptoconditions.CryptoConditionType;
import com.ripple.cryptoconditions.Ed25519Sha256Condition;
import com.ripple.cryptoconditions.NamedInformationUri;
import com.ripple.cryptoconditions.PrefixSha256Condition;
import com.ripple.cryptoconditions.PreimageSha256Condition;
import com.ripple.cryptoconditions.RsaSha256Condition;
import com.ripple.cryptoconditions.SimpleCondition;
import com.ripple.cryptoconditions.ThresholdSha256Condition;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Base64;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CryptoConditionUri {
    public static final String SCHEME_PREFIX = "ni://";
    public static final String HASH_FUNCTION_NAME = "sha-256";
    public static final String CONDITION_REGEX_STRICT = "^ni://([A-Za-z0-9_-]?)/sha-256;([a-zA-Z0-9_-]{0,86})\\?(.+)$";

    public static Condition parse(URI uri) throws URISyntaxException {
        Map<String, List<String>> queryParams;
        Objects.requireNonNull(uri);
        if (!"ni".equals(uri.getScheme())) {
            throw new URISyntaxException(uri.toString(), "Serialized condition must start with 'ni:'");
        }
        Matcher matcher = Pattern.compile(CONDITION_REGEX_STRICT).matcher(uri.toString());
        if (!matcher.matches()) {
            throw new URISyntaxException(uri.toString(), "Invalid condition format");
        }
        try {
            queryParams = CryptoConditionUri.splitQuery(uri.getQuery());
        }
        catch (UnsupportedEncodingException x) {
            throw new URISyntaxException(uri.toString(), "Invalid condition format");
        }
        if (!queryParams.containsKey("fpt")) {
            throw new URISyntaxException(uri.toString(), "No fingerprint type provided");
        }
        CryptoConditionType type = CryptoConditionType.fromString(queryParams.get("fpt").get(0));
        long cost = 0L;
        try {
            cost = Long.parseLong(queryParams.get("cost").get(0));
        }
        catch (NullPointerException | NumberFormatException x) {
            throw new URISyntaxException(uri.toString(), "No or invalid cost provided");
        }
        byte[] fingerprint = Base64.getUrlDecoder().decode(matcher.group(2));
        EnumSet<CryptoConditionType> subtypes = null;
        if (type == CryptoConditionType.PREFIX_SHA256 || type == CryptoConditionType.THRESHOLD_SHA256) {
            if (!queryParams.containsKey("subtypes")) {
                throw new URISyntaxException(uri.toString(), "No subtypes provided");
            }
            subtypes = CryptoConditionType.getEnumOfTypesFromString(queryParams.get("subtypes").get(0));
        }
        switch (type) {
            case PREIMAGE_SHA256: {
                return PreimageSha256Condition.fromCostAndFingerprint(cost, fingerprint);
            }
            case PREFIX_SHA256: {
                return PrefixSha256Condition.fromCostAndFingerprint(cost, fingerprint, subtypes);
            }
            case THRESHOLD_SHA256: {
                return ThresholdSha256Condition.fromCostAndFingerprint(cost, fingerprint, subtypes);
            }
            case RSA_SHA256: {
                return RsaSha256Condition.fromCostAndFingerprint(cost, fingerprint);
            }
            case ED25519_SHA256: {
                return Ed25519Sha256Condition.fromCostAndFingerprint(fingerprint);
            }
        }
        throw new URISyntaxException(uri.toString(), "No or invalid type provided");
    }

    public static URI toUri(Condition condition) {
        if (condition instanceof SimpleCondition) {
            return CryptoConditionUri.writeSingleCondition((SimpleCondition)condition);
        }
        if (condition instanceof CompoundCondition) {
            return CryptoConditionUri.writeCompoundCondition((CompoundCondition)condition);
        }
        throw new IllegalArgumentException(String.format("Unhandled Condition type: %s", condition.getClass().getName()));
    }

    private static URI writeSingleCondition(SimpleCondition condition) {
        Objects.requireNonNull(condition);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fpt", condition.getType().toString().toLowerCase());
        params.put("cost", Long.toString(condition.getCost()));
        return NamedInformationUri.getUri(NamedInformationUri.HashFunction.SHA_256, condition.getFingerprint(), params);
    }

    private static URI writeCompoundCondition(CompoundCondition condition) {
        Objects.requireNonNull(condition);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fpt", condition.getType().toString().toLowerCase());
        params.put("cost", Long.toString(condition.getCost()));
        if (condition.getSubtypes() != null && !condition.getSubtypes().isEmpty()) {
            params.put("subtypes", CryptoConditionType.getEnumOfTypesAsString(condition.getSubtypes()));
        }
        return NamedInformationUri.getUri(NamedInformationUri.HashFunction.SHA_256, condition.getFingerprint(), params);
    }

    private static Map<String, List<String>> splitQuery(String queryParams) throws UnsupportedEncodingException {
        String[] pairs;
        LinkedHashMap<String, List<String>> query_pairs = new LinkedHashMap<String, List<String>>();
        for (String pair : pairs = queryParams.split("&")) {
            String key;
            int idx = pair.indexOf("=");
            String string = key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
            if (!query_pairs.containsKey(key)) {
                query_pairs.put(key, new LinkedList());
            }
            String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : null;
            ((List)query_pairs.get(key)).add(value);
        }
        return query_pairs;
    }

    public static class QueryParams {
        public static final String COST = "cost";
        public static final String TYPE = "fpt";
        public static final String SUBTYPES = "subtypes";
    }
}

