/*
 * Decompiled with CFR 0.152.
 */
package com.ripple.cryptoconditions;

import com.ripple.cryptoconditions.CryptoConditionType;
import com.ripple.cryptoconditions.Ed25519Sha256Condition;
import com.ripple.cryptoconditions.Ed25519Sha256Fulfillment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.i2p.crypto.eddsa.EdDSAPublicKey;

public final class ImmutableEd25519Sha256Fulfillment
extends Ed25519Sha256Fulfillment.AbstractEd25519Sha256Fulfillment {
    private final EdDSAPublicKey publicKey;
    private final byte[] signature;
    private final String signatureBase64Url;
    private final CryptoConditionType type;
    private final Ed25519Sha256Condition derivedCondition;

    private ImmutableEd25519Sha256Fulfillment(EdDSAPublicKey publicKey, byte[] signature, String signatureBase64Url, CryptoConditionType type, Ed25519Sha256Condition derivedCondition) {
        this.publicKey = publicKey;
        this.signature = signature;
        this.signatureBase64Url = signatureBase64Url;
        this.type = type;
        this.derivedCondition = derivedCondition;
    }

    @Override
    public EdDSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    @Deprecated
    public byte[] getSignature() {
        return (byte[])this.signature.clone();
    }

    @Override
    public String getSignatureBase64Url() {
        return this.signatureBase64Url;
    }

    @Override
    public CryptoConditionType getType() {
        return this.type;
    }

    @Override
    public Ed25519Sha256Condition getDerivedCondition() {
        return this.derivedCondition;
    }

    public final ImmutableEd25519Sha256Fulfillment withPublicKey(EdDSAPublicKey value) {
        if (this.publicKey == value) {
            return this;
        }
        EdDSAPublicKey newValue = Objects.requireNonNull(value, "publicKey");
        return new ImmutableEd25519Sha256Fulfillment(newValue, this.signature, this.signatureBase64Url, this.type, this.derivedCondition);
    }

    @Deprecated
    public final ImmutableEd25519Sha256Fulfillment withSignature(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new ImmutableEd25519Sha256Fulfillment(this.publicKey, newValue, this.signatureBase64Url, this.type, this.derivedCondition);
    }

    public final ImmutableEd25519Sha256Fulfillment withSignatureBase64Url(String value) {
        if (this.signatureBase64Url.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "signatureBase64Url");
        return new ImmutableEd25519Sha256Fulfillment(this.publicKey, this.signature, newValue, this.type, this.derivedCondition);
    }

    public final ImmutableEd25519Sha256Fulfillment withType(CryptoConditionType value) {
        if (this.type == value) {
            return this;
        }
        CryptoConditionType newValue = Objects.requireNonNull(value, "type");
        return new ImmutableEd25519Sha256Fulfillment(this.publicKey, this.signature, this.signatureBase64Url, newValue, this.derivedCondition);
    }

    public final ImmutableEd25519Sha256Fulfillment withDerivedCondition(Ed25519Sha256Condition value) {
        if (this.derivedCondition == value) {
            return this;
        }
        Ed25519Sha256Condition newValue = Objects.requireNonNull(value, "derivedCondition");
        return new ImmutableEd25519Sha256Fulfillment(this.publicKey, this.signature, this.signatureBase64Url, this.type, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEd25519Sha256Fulfillment && this.equalTo((ImmutableEd25519Sha256Fulfillment)another);
    }

    private boolean equalTo(ImmutableEd25519Sha256Fulfillment another) {
        return this.publicKey.equals((Object)another.publicKey) && Arrays.equals(this.signature, another.signature) && this.signatureBase64Url.equals(another.signatureBase64Url) && this.type.equals((Object)another.type) && this.derivedCondition.equals(another.derivedCondition);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.publicKey.hashCode();
        h += (h << 5) + Arrays.hashCode(this.signature);
        h += (h << 5) + this.signatureBase64Url.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.derivedCondition.hashCode();
        return h;
    }

    public static ImmutableEd25519Sha256Fulfillment copyOf(Ed25519Sha256Fulfillment.AbstractEd25519Sha256Fulfillment instance) {
        if (instance instanceof ImmutableEd25519Sha256Fulfillment) {
            return (ImmutableEd25519Sha256Fulfillment)instance;
        }
        return ImmutableEd25519Sha256Fulfillment.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PUBLIC_KEY = 1L;
        private static final long INIT_BIT_SIGNATURE = 2L;
        private static final long INIT_BIT_SIGNATURE_BASE64_URL = 4L;
        private static final long INIT_BIT_TYPE = 8L;
        private static final long INIT_BIT_DERIVED_CONDITION = 16L;
        private long initBits = 31L;
        private EdDSAPublicKey publicKey;
        private byte[] signature;
        private String signatureBase64Url;
        private CryptoConditionType type;
        private Ed25519Sha256Condition derivedCondition;

        private Builder() {
        }

        public final Builder from(Ed25519Sha256Fulfillment.AbstractEd25519Sha256Fulfillment instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Ed25519Sha256Fulfillment instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Ed25519Sha256Fulfillment instance;
            if (object instanceof Ed25519Sha256Fulfillment.AbstractEd25519Sha256Fulfillment) {
                instance = (Ed25519Sha256Fulfillment.AbstractEd25519Sha256Fulfillment)object;
                this.type(instance.getType());
                this.derivedCondition((Ed25519Sha256Condition)instance.getDerivedCondition());
            }
            if (object instanceof Ed25519Sha256Fulfillment) {
                instance = (Ed25519Sha256Fulfillment)object;
                this.signature(instance.getSignature());
                this.signatureBase64Url(instance.getSignatureBase64Url());
                this.publicKey(instance.getPublicKey());
            }
        }

        public final Builder publicKey(EdDSAPublicKey publicKey) {
            this.publicKey = Objects.requireNonNull(publicKey, "publicKey");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Deprecated
        public final Builder signature(byte ... signature) {
            this.signature = (byte[])signature.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder signatureBase64Url(String signatureBase64Url) {
            this.signatureBase64Url = Objects.requireNonNull(signatureBase64Url, "signatureBase64Url");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder type(CryptoConditionType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder derivedCondition(Ed25519Sha256Condition derivedCondition) {
            this.derivedCondition = Objects.requireNonNull(derivedCondition, "derivedCondition");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableEd25519Sha256Fulfillment build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEd25519Sha256Fulfillment(this.publicKey, this.signature, this.signatureBase64Url, this.type, this.derivedCondition);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("publicKey");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("signature");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("signatureBase64Url");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("derivedCondition");
            }
            return "Cannot build Ed25519Sha256Fulfillment, some of required attributes are not set " + attributes;
        }
    }
}

