/*
 * Decompiled with CFR 0.152.
 */
package com.ripple.cryptoconditions;

import com.ripple.cryptoconditions.CryptoConditionType;
import com.ripple.cryptoconditions.Fulfillment;
import com.ripple.cryptoconditions.PrefixSha256Condition;
import com.ripple.cryptoconditions.PrefixSha256Fulfillment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public final class ImmutablePrefixSha256Fulfillment
extends PrefixSha256Fulfillment.AbstractPrefixSha256Fulfillment {
    private final byte[] prefix;
    private final String prefixBase64Url;
    private final long maxMessageLength;
    private final Fulfillment subfulfillment;
    private final CryptoConditionType type;
    private final PrefixSha256Condition derivedCondition;

    private ImmutablePrefixSha256Fulfillment(byte[] prefix, String prefixBase64Url, long maxMessageLength, Fulfillment subfulfillment, CryptoConditionType type, PrefixSha256Condition derivedCondition) {
        this.prefix = prefix;
        this.prefixBase64Url = prefixBase64Url;
        this.maxMessageLength = maxMessageLength;
        this.subfulfillment = subfulfillment;
        this.type = type;
        this.derivedCondition = derivedCondition;
    }

    @Override
    @Deprecated
    public byte[] getPrefix() {
        return (byte[])this.prefix.clone();
    }

    @Override
    public String getPrefixBase64Url() {
        return this.prefixBase64Url;
    }

    @Override
    public long getMaxMessageLength() {
        return this.maxMessageLength;
    }

    @Override
    public Fulfillment getSubfulfillment() {
        return this.subfulfillment;
    }

    @Override
    public CryptoConditionType getType() {
        return this.type;
    }

    @Override
    public PrefixSha256Condition getDerivedCondition() {
        return this.derivedCondition;
    }

    @Deprecated
    public final ImmutablePrefixSha256Fulfillment withPrefix(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new ImmutablePrefixSha256Fulfillment(newValue, this.prefixBase64Url, this.maxMessageLength, this.subfulfillment, this.type, this.derivedCondition);
    }

    public final ImmutablePrefixSha256Fulfillment withPrefixBase64Url(String value) {
        if (this.prefixBase64Url.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "prefixBase64Url");
        return new ImmutablePrefixSha256Fulfillment(this.prefix, newValue, this.maxMessageLength, this.subfulfillment, this.type, this.derivedCondition);
    }

    public final ImmutablePrefixSha256Fulfillment withMaxMessageLength(long value) {
        if (this.maxMessageLength == value) {
            return this;
        }
        return new ImmutablePrefixSha256Fulfillment(this.prefix, this.prefixBase64Url, value, this.subfulfillment, this.type, this.derivedCondition);
    }

    public final ImmutablePrefixSha256Fulfillment withSubfulfillment(Fulfillment value) {
        if (this.subfulfillment == value) {
            return this;
        }
        Fulfillment newValue = Objects.requireNonNull(value, "subfulfillment");
        return new ImmutablePrefixSha256Fulfillment(this.prefix, this.prefixBase64Url, this.maxMessageLength, newValue, this.type, this.derivedCondition);
    }

    public final ImmutablePrefixSha256Fulfillment withType(CryptoConditionType value) {
        if (this.type == value) {
            return this;
        }
        CryptoConditionType newValue = Objects.requireNonNull(value, "type");
        return new ImmutablePrefixSha256Fulfillment(this.prefix, this.prefixBase64Url, this.maxMessageLength, this.subfulfillment, newValue, this.derivedCondition);
    }

    public final ImmutablePrefixSha256Fulfillment withDerivedCondition(PrefixSha256Condition value) {
        if (this.derivedCondition == value) {
            return this;
        }
        PrefixSha256Condition newValue = Objects.requireNonNull(value, "derivedCondition");
        return new ImmutablePrefixSha256Fulfillment(this.prefix, this.prefixBase64Url, this.maxMessageLength, this.subfulfillment, this.type, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePrefixSha256Fulfillment && this.equalTo((ImmutablePrefixSha256Fulfillment)another);
    }

    private boolean equalTo(ImmutablePrefixSha256Fulfillment another) {
        return Arrays.equals(this.prefix, another.prefix) && this.prefixBase64Url.equals(another.prefixBase64Url) && this.maxMessageLength == another.maxMessageLength && this.subfulfillment.equals(another.subfulfillment) && this.type.equals((Object)another.type) && this.derivedCondition.equals(another.derivedCondition);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Arrays.hashCode(this.prefix);
        h += (h << 5) + this.prefixBase64Url.hashCode();
        h += (h << 5) + Long.hashCode(this.maxMessageLength);
        h += (h << 5) + this.subfulfillment.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.derivedCondition.hashCode();
        return h;
    }

    public static ImmutablePrefixSha256Fulfillment copyOf(PrefixSha256Fulfillment.AbstractPrefixSha256Fulfillment instance) {
        if (instance instanceof ImmutablePrefixSha256Fulfillment) {
            return (ImmutablePrefixSha256Fulfillment)instance;
        }
        return ImmutablePrefixSha256Fulfillment.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PREFIX = 1L;
        private static final long INIT_BIT_PREFIX_BASE64_URL = 2L;
        private static final long INIT_BIT_MAX_MESSAGE_LENGTH = 4L;
        private static final long INIT_BIT_SUBFULFILLMENT = 8L;
        private static final long INIT_BIT_TYPE = 16L;
        private static final long INIT_BIT_DERIVED_CONDITION = 32L;
        private long initBits = 63L;
        private byte[] prefix;
        private String prefixBase64Url;
        private long maxMessageLength;
        private Fulfillment subfulfillment;
        private CryptoConditionType type;
        private PrefixSha256Condition derivedCondition;

        private Builder() {
        }

        public final Builder from(PrefixSha256Fulfillment instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PrefixSha256Fulfillment.AbstractPrefixSha256Fulfillment instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PrefixSha256Fulfillment instance;
            if (object instanceof PrefixSha256Fulfillment) {
                instance = (PrefixSha256Fulfillment)object;
                this.prefixBase64Url(instance.getPrefixBase64Url());
                this.subfulfillment(instance.getSubfulfillment());
                this.prefix(instance.getPrefix());
                this.maxMessageLength(instance.getMaxMessageLength());
            }
            if (object instanceof PrefixSha256Fulfillment.AbstractPrefixSha256Fulfillment) {
                instance = (PrefixSha256Fulfillment.AbstractPrefixSha256Fulfillment)object;
                this.type(instance.getType());
                this.derivedCondition((PrefixSha256Condition)instance.getDerivedCondition());
            }
        }

        @Deprecated
        public final Builder prefix(byte ... prefix) {
            this.prefix = (byte[])prefix.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder prefixBase64Url(String prefixBase64Url) {
            this.prefixBase64Url = Objects.requireNonNull(prefixBase64Url, "prefixBase64Url");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder maxMessageLength(long maxMessageLength) {
            this.maxMessageLength = maxMessageLength;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder subfulfillment(Fulfillment subfulfillment) {
            this.subfulfillment = Objects.requireNonNull(subfulfillment, "subfulfillment");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder type(CryptoConditionType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder derivedCondition(PrefixSha256Condition derivedCondition) {
            this.derivedCondition = Objects.requireNonNull(derivedCondition, "derivedCondition");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutablePrefixSha256Fulfillment build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePrefixSha256Fulfillment(this.prefix, this.prefixBase64Url, this.maxMessageLength, this.subfulfillment, this.type, this.derivedCondition);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("prefix");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("prefixBase64Url");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("maxMessageLength");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("subfulfillment");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("derivedCondition");
            }
            return "Cannot build PrefixSha256Fulfillment, some of required attributes are not set " + attributes;
        }
    }
}

