/*
 * Decompiled with CFR 0.152.
 */
package com.ripple.cryptoconditions;

import com.ripple.cryptoconditions.CryptoConditionType;
import com.ripple.cryptoconditions.RsaSha256Condition;
import com.ripple.cryptoconditions.RsaSha256Fulfillment;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public final class ImmutableRsaSha256Fulfillment
extends RsaSha256Fulfillment.AbstractRsaSha256Fulfillment {
    private final RSAPublicKey publicKey;
    private final byte[] signature;
    private final String signatureBase64Url;
    private final CryptoConditionType type;
    private final RsaSha256Condition derivedCondition;

    private ImmutableRsaSha256Fulfillment(RSAPublicKey publicKey, byte[] signature, String signatureBase64Url, CryptoConditionType type, RsaSha256Condition derivedCondition) {
        this.publicKey = publicKey;
        this.signature = signature;
        this.signatureBase64Url = signatureBase64Url;
        this.type = type;
        this.derivedCondition = derivedCondition;
    }

    @Override
    public RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    @Deprecated
    public byte[] getSignature() {
        return (byte[])this.signature.clone();
    }

    @Override
    public String getSignatureBase64Url() {
        return this.signatureBase64Url;
    }

    @Override
    public CryptoConditionType getType() {
        return this.type;
    }

    @Override
    public RsaSha256Condition getDerivedCondition() {
        return this.derivedCondition;
    }

    public final ImmutableRsaSha256Fulfillment withPublicKey(RSAPublicKey value) {
        if (this.publicKey == value) {
            return this;
        }
        RSAPublicKey newValue = Objects.requireNonNull(value, "publicKey");
        return new ImmutableRsaSha256Fulfillment(newValue, this.signature, this.signatureBase64Url, this.type, this.derivedCondition);
    }

    @Deprecated
    public final ImmutableRsaSha256Fulfillment withSignature(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new ImmutableRsaSha256Fulfillment(this.publicKey, newValue, this.signatureBase64Url, this.type, this.derivedCondition);
    }

    public final ImmutableRsaSha256Fulfillment withSignatureBase64Url(String value) {
        if (this.signatureBase64Url.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "signatureBase64Url");
        return new ImmutableRsaSha256Fulfillment(this.publicKey, this.signature, newValue, this.type, this.derivedCondition);
    }

    public final ImmutableRsaSha256Fulfillment withType(CryptoConditionType value) {
        if (this.type == value) {
            return this;
        }
        CryptoConditionType newValue = Objects.requireNonNull(value, "type");
        return new ImmutableRsaSha256Fulfillment(this.publicKey, this.signature, this.signatureBase64Url, newValue, this.derivedCondition);
    }

    public final ImmutableRsaSha256Fulfillment withDerivedCondition(RsaSha256Condition value) {
        if (this.derivedCondition == value) {
            return this;
        }
        RsaSha256Condition newValue = Objects.requireNonNull(value, "derivedCondition");
        return new ImmutableRsaSha256Fulfillment(this.publicKey, this.signature, this.signatureBase64Url, this.type, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRsaSha256Fulfillment && this.equalTo((ImmutableRsaSha256Fulfillment)another);
    }

    private boolean equalTo(ImmutableRsaSha256Fulfillment another) {
        return this.publicKey.equals(another.publicKey) && Arrays.equals(this.signature, another.signature) && this.signatureBase64Url.equals(another.signatureBase64Url) && this.type.equals((Object)another.type) && this.derivedCondition.equals(another.derivedCondition);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.publicKey.hashCode();
        h += (h << 5) + Arrays.hashCode(this.signature);
        h += (h << 5) + this.signatureBase64Url.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.derivedCondition.hashCode();
        return h;
    }

    public static ImmutableRsaSha256Fulfillment copyOf(RsaSha256Fulfillment.AbstractRsaSha256Fulfillment instance) {
        if (instance instanceof ImmutableRsaSha256Fulfillment) {
            return (ImmutableRsaSha256Fulfillment)instance;
        }
        return ImmutableRsaSha256Fulfillment.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PUBLIC_KEY = 1L;
        private static final long INIT_BIT_SIGNATURE = 2L;
        private static final long INIT_BIT_SIGNATURE_BASE64_URL = 4L;
        private static final long INIT_BIT_TYPE = 8L;
        private static final long INIT_BIT_DERIVED_CONDITION = 16L;
        private long initBits = 31L;
        private RSAPublicKey publicKey;
        private byte[] signature;
        private String signatureBase64Url;
        private CryptoConditionType type;
        private RsaSha256Condition derivedCondition;

        private Builder() {
        }

        public final Builder from(RsaSha256Fulfillment.AbstractRsaSha256Fulfillment instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RsaSha256Fulfillment instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RsaSha256Fulfillment instance;
            if (object instanceof RsaSha256Fulfillment.AbstractRsaSha256Fulfillment) {
                instance = (RsaSha256Fulfillment.AbstractRsaSha256Fulfillment)object;
                this.type(instance.getType());
                this.derivedCondition((RsaSha256Condition)instance.getDerivedCondition());
            }
            if (object instanceof RsaSha256Fulfillment) {
                instance = (RsaSha256Fulfillment)object;
                this.signature(instance.getSignature());
                this.signatureBase64Url(instance.getSignatureBase64Url());
                this.publicKey(instance.getPublicKey());
            }
        }

        public final Builder publicKey(RSAPublicKey publicKey) {
            this.publicKey = Objects.requireNonNull(publicKey, "publicKey");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Deprecated
        public final Builder signature(byte ... signature) {
            this.signature = (byte[])signature.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder signatureBase64Url(String signatureBase64Url) {
            this.signatureBase64Url = Objects.requireNonNull(signatureBase64Url, "signatureBase64Url");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder type(CryptoConditionType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder derivedCondition(RsaSha256Condition derivedCondition) {
            this.derivedCondition = Objects.requireNonNull(derivedCondition, "derivedCondition");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableRsaSha256Fulfillment build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRsaSha256Fulfillment(this.publicKey, this.signature, this.signatureBase64Url, this.type, this.derivedCondition);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("publicKey");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("signature");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("signatureBase64Url");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("derivedCondition");
            }
            return "Cannot build RsaSha256Fulfillment, some of required attributes are not set " + attributes;
        }
    }
}

